/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.config;

import com.google.gson.annotations.SerializedName;
import de.otto.jlineup.config.Config;
import de.otto.jlineup.config.Cookie;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class UrlConfig {
    public final List<String> paths;
    @SerializedName(value="max-diff")
    public final float maxDiff;
    public final List<Cookie> cookies;
    @SerializedName(value="env-mapping")
    public final Map<String, String> envMapping;
    @SerializedName(value="local-storage")
    public final Map<String, String> localStorage;
    @SerializedName(value="window-widths", alternate={"resolutions", "widths"})
    public final List<Integer> windowWidths;
    @SerializedName(value="max-scroll-height")
    public final int maxScrollHeight;
    @SerializedName(value="wait-after-page-load")
    public final int waitAfterPageLoad;
    @SerializedName(value="wait-for-no-animation-after-scroll")
    public final float waitForNoAnimationAfterScroll;
    @SerializedName(value="warmup-browser-cache-time")
    private final Integer warmupBrowserCacheTime;

    public UrlConfig() {
        this.paths = Config.DEFAULT_PATHS;
        this.windowWidths = Config.DEFAULT_WINDOW_WIDTHS;
        this.maxDiff = 0.0f;
        this.cookies = null;
        this.localStorage = null;
        this.maxScrollHeight = 100000;
        this.waitAfterPageLoad = 0;
        this.waitForNoAnimationAfterScroll = 0.0f;
        this.envMapping = null;
        this.warmupBrowserCacheTime = null;
    }

    public UrlConfig(List<String> paths, float maxDiff, List<Cookie> cookies, Map<String, String> envMapping, Map<String, String> localStorage, List<Integer> windowWidths, int maxScrollHeight, int waitAfterPageLoad, float waitForNoAnimationAfterScroll, Integer warmupBrowserCacheTime) {
        this.paths = paths != null ? paths : Config.DEFAULT_PATHS;
        this.windowWidths = windowWidths != null ? windowWidths : Config.DEFAULT_WINDOW_WIDTHS;
        this.maxDiff = maxDiff;
        this.cookies = cookies;
        this.envMapping = envMapping;
        this.localStorage = localStorage;
        this.maxScrollHeight = maxScrollHeight;
        this.waitAfterPageLoad = waitAfterPageLoad;
        this.waitForNoAnimationAfterScroll = waitForNoAnimationAfterScroll;
        this.warmupBrowserCacheTime = warmupBrowserCacheTime;
    }

    public String toString() {
        return "UrlConfig{paths=" + this.paths + ", maxDiff=" + this.maxDiff + ", cookies=" + this.cookies + ", envMapping=" + this.envMapping + ", localStorage=" + this.localStorage + ", windowWidths=" + this.windowWidths + ", maxScrollHeight=" + this.maxScrollHeight + ", waitAfterPageLoad=" + this.waitAfterPageLoad + ", waitForNoAnimationAfterScroll=" + this.waitForNoAnimationAfterScroll + ", warmupBrowserCacheTime=" + this.warmupBrowserCacheTime + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlConfig urlConfig = (UrlConfig)o;
        return Float.compare(urlConfig.maxDiff, this.maxDiff) == 0 && Objects.equals(this.paths, urlConfig.paths) && Objects.equals(this.cookies, urlConfig.cookies) && Objects.equals(this.envMapping, urlConfig.envMapping) && Objects.equals(this.localStorage, urlConfig.localStorage) && Objects.equals(this.windowWidths, urlConfig.windowWidths) && Objects.equals(this.maxScrollHeight, urlConfig.maxScrollHeight) && Objects.equals(this.waitAfterPageLoad, urlConfig.waitAfterPageLoad) && Objects.equals(Float.valueOf(this.waitForNoAnimationAfterScroll), Float.valueOf(urlConfig.waitForNoAnimationAfterScroll)) && Objects.equals(this.warmupBrowserCacheTime, urlConfig.warmupBrowserCacheTime);
    }

    public int hashCode() {
        return Objects.hash(this.paths, Float.valueOf(this.maxDiff), this.cookies, this.envMapping, this.localStorage, this.windowWidths, this.maxScrollHeight, this.waitAfterPageLoad, Float.valueOf(this.waitForNoAnimationAfterScroll), this.warmupBrowserCacheTime);
    }

    public Optional<Integer> getWarmupBrowserCacheTime() {
        return Optional.ofNullable(this.warmupBrowserCacheTime);
    }
}

