/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.browser;

import de.otto.jlineup.browser.JLineupGeckoDriverService;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.Config;
import de.otto.jlineup.config.Parameters;
import de.otto.jlineup.config.UrlConfig;
import io.github.bonigarcia.wdm.ChromeDriverManager;
import io.github.bonigarcia.wdm.MarionetteDriverManager;
import io.github.bonigarcia.wdm.PhantomJsDriverManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.firefox.MarionetteDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class BrowserUtils {
    public static String buildUrl(String url, String path, Map<String, String> envMapping) {
        if (envMapping != null && !envMapping.isEmpty()) {
            for (Map.Entry<String, String> envMappingEntry : envMapping.entrySet()) {
                String fromEnvironment = envMappingEntry.getKey();
                String toEnvironment = envMappingEntry.getValue();
                url = url.replace("https://" + fromEnvironment + ".", "https://" + toEnvironment + ".");
                url = url.replace("http://" + fromEnvironment + ".", "http://" + toEnvironment + ".");
                url = url.replace("." + fromEnvironment + ".", "." + toEnvironment + ".");
            }
        }
        return BrowserUtils.buildUrl(url, path);
    }

    public static String buildUrl(String url, String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url + path;
    }

    public static WebDriver getWebDriverByConfig(Config config) {
        RemoteWebDriver driver;
        switch (config.browser) {
            case FIREFOX: {
                MarionetteDriverManager.getInstance().setup();
                JLineupGeckoDriverService.Builder builder = new JLineupGeckoDriverService.Builder();
                builder.usingPort(0);
                driver = new MarionetteDriver((GeckoDriverService)builder.build());
                break;
            }
            case CHROME: {
                ChromeDriverManager.getInstance().setup();
                ChromeOptions options = new ChromeOptions();
                options.addArguments("--no-sandbox");
                driver = new ChromeDriver(options);
                break;
            }
            default: {
                PhantomJsDriverManager.getInstance().setup();
                driver = new PhantomJSDriver();
            }
        }
        return driver;
    }

    public static List<ScreenshotContext> buildScreenshotContextListFromConfigAndState(Parameters parameters, Config config, boolean before) {
        ArrayList<ScreenshotContext> screenshotContextList = new ArrayList<ScreenshotContext>();
        Map<String, UrlConfig> urls = config.urls;
        for (Map.Entry<String, UrlConfig> urlConfigEntry : urls.entrySet()) {
            UrlConfig urlConfig = urlConfigEntry.getValue();
            List<Integer> resolutions = urlConfig.windowWidths;
            List<String> paths = urlConfig.paths;
            for (String path : paths) {
                screenshotContextList.addAll(resolutions.stream().map(windowWidth -> new ScreenshotContext(BrowserUtils.prepareDomain(parameters, (String)urlConfigEntry.getKey()), path, (int)windowWidth, before, (UrlConfig)urlConfigEntry.getValue())).collect(Collectors.toList()));
            }
        }
        return screenshotContextList;
    }

    public static String prepareDomain(Parameters parameters, String url) {
        String processedUrl = url;
        for (Map.Entry<String, String> replacement : parameters.getUrlReplacements().entrySet()) {
            processedUrl = processedUrl.replace(replacement.getKey(), replacement.getValue());
        }
        return processedUrl;
    }

    public static String prependHTTPIfNotThereAndToLowerCase(String url) {
        String ret = url.toLowerCase();
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            ret = "http://" + ret;
        }
        return ret;
    }
}

