/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.service;

import de.otto.jlineup.file.FileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class Housekeeper {
    private static final int DELETE_REPORTS_AFTER_DAYS = 7;
    private static final int DELETE_SCREENSHOTS_AFTER_DAYS = 1;
    private static final int ONE_HOUR_IN_MILLIS = 3600000;
    private static final String SELENIUM_SCREENSHOT_PREFIX = "screenshot";
    private static final String SELENIUM_SCREENSHOT_EXTENTION = ".png";
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Path path;

    public Housekeeper(Path path) {
        this.path = path;
    }

    @Scheduled(fixedRate=3600000L)
    public void deleteOldFiles() throws IOException {
        this.deleteReportsOlderThan(Duration.ofDays(7L));
        this.deleteSeleniumScreenshotsOlderThan(Duration.ofDays(1L));
    }

    private void deleteSeleniumScreenshotsOlderThan(Duration duration) throws IOException {
        Instant pointInTime = Instant.now().minus(duration);
        LOG.info("delete selenium screenshots older than {}", (Object)pointInTime);
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File[] screenShotFiles = tmpDir.listFiles((dir, fileName) -> fileName.startsWith(SELENIUM_SCREENSHOT_PREFIX) && fileName.endsWith(SELENIUM_SCREENSHOT_EXTENTION));
        if (screenShotFiles != null) {
            Stream.of(screenShotFiles).map(File::toPath).filter(this.filesOlderThan(pointInTime)).forEach(arg_0 -> this.deleteFile(arg_0));
        }
    }

    private void deleteReportsOlderThan(Duration duration) throws IOException {
        Instant pointInTime = Instant.now().minus(duration);
        LOG.info("delete reports older than {}", (Object)pointInTime);
        Files.list(this.path).filter(this.filesOlderThan(pointInTime)).forEach(this.deletePath());
    }

    private void deleteFile(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Consumer<Path> deletePath() {
        return file -> {
            try {
                FileUtils.deleteDirectory((Path)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
    }

    private Predicate<Path> filesOlderThan(Instant pointInTime) {
        return file -> {
            try {
                Instant fileDate = Files.getLastModifiedTime(file, new LinkOption[0]).toInstant();
                return fileDate.isBefore(pointInTime);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        };
    }
}

