/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.jlineup.service.RunPersistenceService;
import de.otto.jlineup.web.JLineupRunStatus;
import de.otto.jlineup.web.State;
import de.otto.jlineup.web.configuration.JLineupWebProperties;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RunPersistenceService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String RUNS_FILENAME = "runs.json";
    public static final int MAX_PERSISTED_RUNS = 100;
    private final JLineupWebProperties jLineupWebProperties;
    private final ObjectMapper objectMapper;

    @Autowired
    public RunPersistenceService(JLineupWebProperties jLineupWebProperties, ObjectMapper objectMapper) {
        this.jLineupWebProperties = jLineupWebProperties;
        this.objectMapper = objectMapper;
    }

    void persistRuns(Map<String, JLineupRunStatus> runs) {
        Comparator<JLineupRunStatus> comparator = Comparator.comparing(JLineupRunStatus::getStartTime);
        try {
            Map<String, JLineupRunStatus> mapWithLatestEntries = runs.entrySet().stream().sorted(Map.Entry.comparingByValue(comparator).reversed()).limit(100L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            String serializedRuns = this.objectMapper.writeValueAsString(mapWithLatestEntries);
            Path path = this.getRunsFilePath();
            Files.write(path, serializedRuns.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.error("Serialization of runs failed. Please file a bug report at https://github.com/otto-de/jlineup/issues", (Throwable)e);
        }
    }

    Map<String, JLineupRunStatus> readRuns() {
        if (Files.exists(this.getRunsFilePath(), new LinkOption[0])) {
            try {
                1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
                Map loadedRuns = (Map)this.objectMapper.readValue(this.getRunsFilePath().toFile(), (TypeReference)typeRef);
                return loadedRuns.entrySet().stream().map(entry -> {
                    if (((JLineupRunStatus)entry.getValue()).getState().isNonPersistable()) {
                        return new AbstractMap.SimpleEntry<String, JLineupRunStatus>((String)entry.getKey(), JLineupRunStatus.copyOfRunStatusBuilder((JLineupRunStatus)((JLineupRunStatus)entry.getValue())).withState(State.DEAD).build());
                    }
                    return entry;
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            catch (IOException e) {
                LOG.error("Could not read runs file, it seems to be broken or incompatible. If this problem reappears, delete '{}'.", (Object)this.getRunsFilePath().toString(), (Object)e);
            }
        }
        return Collections.emptyMap();
    }

    private Path getRunsFilePath() {
        return Paths.get(this.jLineupWebProperties.getWorkingDirectory(), RUNS_FILENAME);
    }
}

