/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.web;

import de.otto.jlineup.service.JLineupService;
import de.otto.jlineup.web.JLineupRunStatus;
import de.otto.jlineup.web.State;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class ReportController {
    private JLineupService jLineupService;
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd kk:mm").withZone(ZoneId.systemDefault());

    @Autowired
    public ReportController(JLineupService jLineupService) {
        this.jLineupService = jLineupService;
    }

    @RequestMapping(value={"${edison.application.management.base-path:/internal}/reports"}, produces={"text/html"}, method={RequestMethod.GET})
    public ModelAndView getReports() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static String getDurationAsString(JLineupRunStatus status) {
        AtomicLong durationMillis = new AtomicLong();
        Instant startTime = status.getStartTime();
        status.getPauseTime().ifPresent(pauseTime -> durationMillis.addAndGet(Duration.between(startTime, pauseTime).toMillis()));
        status.getEndTime().ifPresent(endTime -> durationMillis.addAndGet(Duration.between(status.getResumeTime().orElse(endTime), endTime).toMillis()));
        if (status.getState() == State.BEFORE_RUNNING) {
            durationMillis.addAndGet(Duration.between(startTime, Instant.now()).toMillis());
        } else if (status.getState() == State.AFTER_RUNNING) {
            durationMillis.addAndGet(Duration.between(status.getResumeTime().orElse(Instant.now()), Instant.now()).toMillis());
        }
        return DurationFormatUtils.formatDuration((long)durationMillis.get(), (String)"HH:mm:ss");
    }

    private static String formatTime(Instant time) {
        return dateTimeFormatter.format(time);
    }
}

