/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.web.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.jlineup.web.configuration.JLineupWebProperties;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
public class MyWebMvcConfigurationSupport
extends WebMvcConfigurationSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ObjectMapper objectMapper;
    @Autowired
    private JLineupWebProperties properties;

    @Autowired
    public MyWebMvcConfigurationSupport(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(this.objectMapper));
        this.addDefaultHttpMessageConverters(converters);
        super.configureMessageConverters(converters);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        try {
            Files.createDirectories(Paths.get(this.properties.getWorkingDirectory(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.error("Cannot create JLineup working directory.", (Throwable)e);
        }
        registry.addResourceHandler(new String[]{"/reports/**"}).addResourceLocations(new String[]{"file:" + this.properties.getWorkingDirectory()}).setCachePeriod(Integer.valueOf(0));
    }
}

