/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.web;

import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.google.common.collect.ImmutableMap;
import de.otto.jlineup.browser.Browser;
import de.otto.jlineup.config.ConfigMerger;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.UrlConfig;
import de.otto.jlineup.exceptions.ValidationError;
import de.otto.jlineup.service.BrowserNotInstalledException;
import de.otto.jlineup.service.InvalidRunStateException;
import de.otto.jlineup.service.JLineupService;
import de.otto.jlineup.service.RunNotFoundException;
import de.otto.jlineup.web.JLineupRunStatus;
import de.otto.jlineup.web.RunBeforeResponse;
import de.otto.jlineup.web.State;
import de.otto.jlineup.web.configuration.JLineupWebProperties;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JLineupController {
    private final JLineupService jLineupService;
    private final JLineupWebProperties properties;
    private AtomicReference<String> currentExampleRun = new AtomicReference();

    @Autowired
    public JLineupController(JLineupService jLineupService, JLineupWebProperties properties) {
        this.jLineupService = jLineupService;
        this.properties = properties;
    }

    @GetMapping(value={"/"})
    public String getHello(HttpServletRequest request) {
        return String.format("<p>JLineup is great! Do you want to go to my <a href=\"%s/internal/status\">status page</a>?</p>", request.getContextPath());
    }

    @PostMapping(value={"/runs"})
    public ResponseEntity<RunBeforeResponse> runBefore(@RequestBody JobConfig jobConfig, HttpServletRequest request) throws Exception {
        if (jobConfig.mergeConfig != null) {
            JobConfig mainGlobalConfig = JobConfig.copyOfBuilder((JobConfig)jobConfig).withMergeConfig(null).build();
            JobConfig mergeGlobalConfig = jobConfig.mergeConfig;
            jobConfig = ConfigMerger.mergeJobConfigWithMergeConfig((JobConfig)mainGlobalConfig, (JobConfig)mergeGlobalConfig);
        }
        String id = this.jLineupService.startBeforeRun(jobConfig.insertDefaults()).getId();
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(URI.create(request.getContextPath() + "/runs/" + id));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().headers(headers)).body((Object)new RunBeforeResponse(id));
    }

    @GetMapping(value={"/exampleRun"})
    public String exampleRun(@RequestParam(value="url", required=false) String url, @RequestParam(value="browser", required=false) String browser, HttpServletRequest request) throws Exception {
        State state;
        Optional run;
        String exampleRunId = (String)this.currentExampleRun.get();
        if (exampleRunId != null && (run = this.jLineupService.getRun(exampleRunId)).isPresent() && !(state = ((JLineupRunStatus)run.get()).getState()).isDone()) {
            if (state == State.BEFORE_DONE) {
                this.jLineupService.startAfterRun(((JLineupRunStatus)run.get()).getId());
                return "Example run entered 'after' step.";
            }
            return "Example run is currently running. The current state is " + state;
        }
        if (url == null) {
            url = "https://www.example.com";
        }
        JobConfig.Builder jobConfigBuilder = JobConfig.jobConfigBuilder().withBrowser((Browser.Type)this.properties.getInstalledBrowsers().get(0)).withName("Example run").withUrls((Map)ImmutableMap.of((Object)url, (Object)UrlConfig.urlConfigBuilder().build()));
        if (browser != null) {
            try {
                Browser.Type type = Browser.Type.forValue((String)browser);
                jobConfigBuilder.withBrowser(type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentExampleRun.set(this.jLineupService.startBeforeRun(jobConfigBuilder.build().insertDefaults()).getId());
        return "Example run started with 'before' step with Browser '" + jobConfigBuilder.build().insertDefaults().browser + "'.";
    }

    @PostMapping(value={"/runs/{runId}"})
    public ResponseEntity<Void> runAfter(@PathVariable String runId, HttpServletRequest request) throws Exception {
        String sanitizedRunId = this.validateAndSanitizeRunId(runId);
        this.jLineupService.startAfterRun(sanitizedRunId);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(URI.create(request.getContextPath() + "/runs/" + sanitizedRunId));
        return new ResponseEntity((MultiValueMap)headers, (HttpStatusCode)HttpStatus.ACCEPTED);
    }

    @GetMapping(value={"/runs/{runId}"})
    public ResponseEntity<JLineupRunStatus> getRun(@PathVariable String runId) throws RunNotFoundException {
        String sanitizedRunId = this.validateAndSanitizeRunId(runId);
        Optional run = this.jLineupService.getRun(sanitizedRunId);
        return run.map(jLineupRunStatus -> new ResponseEntity(jLineupRunStatus, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    private String validateAndSanitizeRunId(String runId) throws RunNotFoundException {
        try {
            UUID uuid = UUID.fromString(runId);
            return uuid.toString();
        }
        catch (IllegalArgumentException e) {
            throw new RunNotFoundException(runId);
        }
    }

    @ExceptionHandler(value={RunNotFoundException.class})
    public ResponseEntity<String> exceptionHandler(RunNotFoundException exception) {
        return new ResponseEntity((Object)String.format("Run with id '%s' was not found", exception.getId()), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={InvalidRunStateException.class})
    public ResponseEntity<String> exceptionHandler(InvalidRunStateException exception) {
        return new ResponseEntity((Object)String.format("Run with id '%s' has wrong state. was %s but expected %s", exception.getId(), exception.getCurrentState(), exception.getExpectedState()), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
    }

    @ExceptionHandler(value={BrowserNotInstalledException.class})
    public ResponseEntity<String> exceptionHandler(BrowserNotInstalledException exception) {
        return new ResponseEntity((Object)String.format("Browser %s is not installed or not configured on server side.", exception.getDesiredBrowser().name()), (HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={InvalidDefinitionException.class})
    public ResponseEntity<String> exceptionHandler(InvalidDefinitionException exception) {
        return new ResponseEntity((Object)exception.getCause().getMessage(), (HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={ValidationError.class})
    public ResponseEntity<String> exceptionHandler(ValidationError exception) {
        return new ResponseEntity((Object)exception.getMessage(), (HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<String> exceptionHandler(IllegalArgumentException exception) {
        return new ResponseEntity((Object)exception.getMessage(), (HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
    }
}

