/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.lambda;

import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.browser.Browser;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.JobConfigValidator;
import de.otto.jlineup.exceptions.ValidationError;
import de.otto.jlineup.file.FileService;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LambdaRunner {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String REPORT_LOG_NAME_KEY = "reportlogname";
    public static final String LOGFILE_NAME = "jlineup.log";
    private final JobConfig jobConfig;
    private final RunStepConfig runStepConfig;
    private final ScreenshotContext screenshotContext;

    public LambdaRunner(JobConfig jobConfig, RunStepConfig runStepConfig, ScreenshotContext screenshotContext) throws ValidationError {
        this.jobConfig = jobConfig;
        this.runStepConfig = runStepConfig;
        this.screenshotContext = screenshotContext;
        this.validateConfig();
    }

    public boolean run() {
        FileService fileService = new FileService(this.runStepConfig, this.jobConfig);
        try {
            fileService.createWorkingDirectoryIfNotExists();
            fileService.createOrClearReportDirectory(this.runStepConfig.isKeepExisting());
            fileService.createOrClearScreenshotsDirectory(this.runStepConfig.isKeepExisting());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MDC.put((String)REPORT_LOG_NAME_KEY, (String)(BrowserUtils.getFullPathOfReportDir((RunStepConfig)this.runStepConfig) + "/jlineup.log"));
        LOG.info("JLineup run started for context '{}'", (Object)this.screenshotContext);
        BrowserUtils browserUtils = new BrowserUtils();
        try (Browser browser = new Browser(this.runStepConfig, this.jobConfig, fileService, browserUtils);){
            browser.runForScreenshotContext(this.screenshotContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.info("JLineup run finished for context '{}'", (Object)this.screenshotContext);
        MDC.remove((String)REPORT_LOG_NAME_KEY);
        return true;
    }

    private void validateConfig() throws ValidationError {
        JobConfigValidator.validateJobConfig((JobConfig)this.jobConfig);
    }
}

