/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.Utils;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.RunStep;
import de.otto.jlineup.config.UrlConfig;
import de.otto.jlineup.lambda.LambdaProperties;
import de.otto.jlineup.lambda.LambdaRequestPayload;
import de.otto.jlineup.lambda.LambdaRunner;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.transfer.s3.CompletedDirectoryUpload;
import software.amazon.awssdk.transfer.s3.S3ClientConfiguration;
import software.amazon.awssdk.transfer.s3.S3TransferManager;

public class JLineupHandler
implements RequestStreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JLineupHandler.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private S3TransferManager transferManager;

    public void handleRequest(InputStream input, OutputStream output, Context context) {
        try {
            LambdaRequestPayload event = (LambdaRequestPayload)this.objectMapper.readValue(input, LambdaRequestPayload.class);
            ScreenshotContext screenshotContext = ScreenshotContext.copyOfBuilder((ScreenshotContext)event.screenshotContext).withStep(event.step.toBrowserStep()).withUrlConfig((UrlConfig)event.jobConfig.urls.get(event.screenshotContext.url)).build();
            LambdaRunner runner = this.createRun(event.runId, event.step, event.jobConfig, screenshotContext);
            runner.run();
            AwsCredentialsProviderChain cp = AwsCredentialsProviderChain.builder().credentialsProviders(new AwsCredentialsProvider[]{ContainerCredentialsProvider.builder().build(), EnvironmentVariableCredentialsProvider.create(), ProfileCredentialsProvider.builder().profileName(LambdaProperties.getProfile()).build()}).build();
            this.transferManager = S3TransferManager.builder().s3ClientConfiguration((S3ClientConfiguration)S3ClientConfiguration.builder().credentialsProvider((AwsCredentialsProvider)cp).build()).build();
            CompletableFuture uploadStatus = this.transferManager.uploadDirectory(r -> r.bucket("jlineuptest-marco").sourceDirectory(Paths.get("/tmp/jlineup/run-" + event.runId, new String[0]))).completionFuture();
            System.out.println(((CompletedDirectoryUpload)uploadStatus.get()).toString());
            output.write("Ok!".getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private LambdaRunner createRun(String id, RunStep step, JobConfig jobConfig, ScreenshotContext screenshotContext) {
        RunStepConfig runStepConfig = RunStepConfig.runStepConfigBuilder().withWebDriverCachePath("/tmp/jlineup/webdrivers").withWorkingDirectory("/tmp/jlineup/run-{id}".replace("{id}", id)).withScreenshotsDirectory("jlineup-{id}".replace("{id}", id)).withReportDirectory("jlineup-{id}".replace("{id}", id)).withChromeParameters((List)ImmutableList.of((Object)"--headless=new", (Object)"--disable-gpu", (Object)"--no-sandbox", (Object)"--use-spdy=off", (Object)"--disable-dev-shm-usage", (Object)"--disable-web-security", (Object)"--no-zygote", (Object)"--force-color-profile=srgb", (Object)("--user-data-dir=/tmp/jlineup/chrome-profile-" + id))).withStep(step).build();
        return new LambdaRunner(jobConfig, runStepConfig, screenshotContext);
    }

    static {
        Utils.setDebugLogLevelsOfSelectedThirdPartyLibsToWarn();
    }
}

