/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.lambda;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.jlineup.browser.CloudBrowser;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.lambda.AWSConfig;
import de.otto.jlineup.lambda.LambdaProperties;
import de.otto.jlineup.lambda.LambdaRequestPayload;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.LambdaClientBuilder;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.ServiceException;
import software.amazon.awssdk.transfer.s3.S3ClientConfiguration;
import software.amazon.awssdk.transfer.s3.S3TransferManager;

public class LambdaBrowser
implements CloudBrowser {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final JobConfig jobConfig;
    private final FileService fileService;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public LambdaBrowser(JobConfig jobConfig, FileService fileService) {
        this.fileService = fileService;
        this.jobConfig = jobConfig;
    }

    public void takeScreenshots(List<ScreenshotContext> screenshotContexts) throws ExecutionException, InterruptedException {
        String runId = UUID.randomUUID().toString();
        HashSet<Future<InvokeResponse>> lambdaCalls = new HashSet<Future<InvokeResponse>>();
        for (ScreenshotContext screenshotContext : screenshotContexts) {
            InvokeRequest invokeRequest;
            try {
                invokeRequest = (InvokeRequest)InvokeRequest.builder().functionName("jlineup-run").payload(SdkBytes.fromUtf8String((String)this.objectMapper.writeValueAsString((Object)new LambdaRequestPayload(runId, this.jobConfig, screenshotContext, screenshotContext.step)))).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            try {
                LambdaClient lambdaClient = (LambdaClient)((LambdaClientBuilder)((LambdaClientBuilder)LambdaClient.builder().credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).region(Region.EU_CENTRAL_1)).build();
                try {
                    Future<InvokeResponse> invokeResponseFuture = this.executor.submit(() -> lambdaClient.invoke(invokeRequest));
                    lambdaCalls.add(invokeResponseFuture);
                }
                finally {
                    if (lambdaClient == null) continue;
                    lambdaClient.close();
                }
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        for (Future future : lambdaCalls) {
            InvokeResponse invokeResponse = (InvokeResponse)future.get();
            String answer = invokeResponse.payload().asUtf8String();
            String logResult = invokeResponse.logResult();
            System.out.println(answer);
            System.out.println(logResult);
        }
        AwsCredentialsProvider cp = null;
        try {
            cp = AWSConfig.defaultAwsCredentialsProvider((String)LambdaProperties.getProfile());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        S3TransferManager s3TransferManager = S3TransferManager.builder().s3ClientConfiguration((S3ClientConfiguration)S3ClientConfiguration.builder().credentialsProvider(cp).build()).build();
        CompletableFuture download = s3TransferManager.downloadDirectory(d -> d.bucket("jlineuptest-marco").prefix("jlineup-" + runId).destinationDirectory(Paths.get("/tmp/jlineup-s3download/" + runId, new String[0]))).completionFuture();
    }
}

