/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.ImmutableList;
import de.otto.jlineup.GlobalOption;
import de.otto.jlineup.GlobalOptions;
import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.Utils;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.RunStep;
import de.otto.jlineup.config.UrlConfig;
import de.otto.jlineup.file.FileUtils;
import de.otto.jlineup.lambda.LambdaRequestPayload;
import de.otto.jlineup.lambda.LambdaRunner;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.CompletedDirectoryUpload;

public class JLineupHandler
implements RequestStreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JLineupHandler.class);
    private final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.USE_ANNOTATIONS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).build();
    private S3TransferManager transferManager;

    public void handleRequest(InputStream input, OutputStream output, Context context) {
        try {
            String bucketName;
            LambdaRequestPayload event = (LambdaRequestPayload)this.objectMapper.readValue(input, LambdaRequestPayload.class);
            ScreenshotContext screenshotContext = ScreenshotContext.copyOfBuilder((ScreenshotContext)event.screenshotContext).withStep(event.step.toBrowserStep()).withUrlKey(event.urlKey).withUrlConfig((UrlConfig)event.jobConfig.urls.get(event.screenshotContext.urlKey)).build();
            LambdaRunner runner = this.createRun(event.runId, event.step == RunStep.after ? RunStep.after_only : event.step, event.jobConfig, screenshotContext);
            int retries = runner.run();
            AwsCredentialsProviderChain cp = AwsCredentialsProviderChain.builder().credentialsProviders(new AwsCredentialsProvider[]{ContainerCredentialsProvider.builder().build(), EnvironmentVariableCredentialsProvider.create(), ProfileCredentialsProvider.builder().profileName(GlobalOptions.getOption((GlobalOption)GlobalOption.JLINEUP_LAMBDA_AWS_PROFILE)).build()}).build();
            this.transferManager = S3TransferManager.builder().s3Client(S3AsyncClient.crtBuilder().credentialsProvider((AwsCredentialsProvider)cp).build()).build();
            Path logfile = Paths.get(BrowserUtils.getFullPathOfReportDir((RunStepConfig)runner.getRunStepConfig()) + "/jlineup.log", new String[0]);
            Path workingDir = Paths.get("/tmp/jlineup/run-" + event.runId, new String[0]);
            if (Files.exists(logfile, new LinkOption[0])) {
                Files.move(logfile, Paths.get(BrowserUtils.getFullPathOfReportDir((RunStepConfig)runner.getRunStepConfig()) + "/context_" + screenshotContext.contextHash() + "_jlineup.log", new String[0]), new CopyOption[0]);
            }
            if ((bucketName = GlobalOptions.getOption((GlobalOption)GlobalOption.JLINEUP_LAMBDA_S3_BUCKET)) == null) {
                throw new RuntimeException("Environment variable JLINEUP_LAMBDA_S3_BUCKET not set! Please create a bucket and set the environment variable to contain it's name.");
            }
            CompletableFuture uploadStatus = this.transferManager.uploadDirectory(r -> r.bucket(bucketName).source(workingDir)).completionFuture();
            CompletedDirectoryUpload completedDirectoryUpload = (CompletedDirectoryUpload)uploadStatus.get();
            output.write(("OK! S3 upload status: " + completedDirectoryUpload.toString() + " - Retries: " + retries).getBytes(StandardCharsets.UTF_8));
            FileUtils.deleteDirectory((Path)workingDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private LambdaRunner createRun(String id, RunStep step, JobConfig jobConfig, ScreenshotContext screenshotContext) {
        RunStepConfig runStepConfig = RunStepConfig.runStepConfigBuilder().withWebDriverCachePath("/tmp/jlineup/webdrivers").withWorkingDirectory("/tmp/jlineup/run-{id}".replace("{id}", id)).withScreenshotsDirectory("jlineup-{id}".replace("{id}", id)).withReportDirectory("jlineup-{id}".replace("{id}", id)).withChromeParameters((List)ImmutableList.of((Object)"--single-process", (Object)"--headless=new", (Object)"--enable-logging", (Object)"--v=1", (Object)"--disable-gpu", (Object)"--no-sandbox", (Object)"--use-spdy=off", (Object)"--disable-dev-shm-usage", (Object)"--disable-web-security", (Object)"--no-zygote", (Object)"--force-color-profile=srgb", (Object)"--hide-scrollbars", (Object[])new String[]{"--user-data-dir=/tmp/jlineup/chrome-profile-" + id})).withStep(step).build();
        return new LambdaRunner(id, jobConfig, runStepConfig, screenshotContext);
    }

    static {
        Utils.setDebugLogLevelsOfSelectedThirdPartyLibsToWarn();
    }
}

