/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.lambda;

import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.browser.Browser;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.JobConfigValidator;
import de.otto.jlineup.exceptions.ValidationError;
import de.otto.jlineup.file.FileService;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LambdaRunner {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String REPORT_LOG_NAME_KEY = "reportlogname";
    public static final String LOGFILE_NAME = "jlineup.log";
    private final JobConfig jobConfig;
    private final RunStepConfig runStepConfig;
    private final ScreenshotContext screenshotContext;
    private final String id;

    public RunStepConfig getRunStepConfig() {
        return this.runStepConfig;
    }

    public LambdaRunner(String id, JobConfig jobConfig, RunStepConfig runStepConfig, ScreenshotContext screenshotContext) throws ValidationError {
        this.id = id;
        this.jobConfig = jobConfig;
        this.runStepConfig = runStepConfig;
        this.screenshotContext = screenshotContext;
        this.validateConfig();
    }

    public int run() {
        FileService fileService = new FileService(this.runStepConfig, this.jobConfig, "files_" + this.runStepConfig.getStep() + "_" + this.screenshotContext.contextHash() + ".json");
        try {
            fileService.createWorkingDirectoryIfNotExists();
            fileService.createOrClearReportDirectory(this.runStepConfig.isKeepExisting());
            fileService.createOrClearScreenshotsDirectory(this.runStepConfig.isKeepExisting());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MDC.put((String)REPORT_LOG_NAME_KEY, (String)(BrowserUtils.getFullPathOfReportDir((RunStepConfig)this.runStepConfig) + "/jlineup.log"));
        LOG.info("JLineup run started for context '{}'", (Object)this.screenshotContext);
        BrowserUtils browserUtils = new BrowserUtils();
        int retries = 0;
        try (Browser browser = new Browser(this.runStepConfig, this.jobConfig, fileService, browserUtils);){
            retries = this.tryToTakeScreenshotsForContextNTimes(browser, this.screenshotContext, this.jobConfig.screenshotRetries);
            if (retries > 0) {
                LOG.warn("It took '{}' retries to take screenshots", (Object)retries);
            }
        }
        catch (Exception exception) {
            Path pathToDebugFile = Paths.get("/tmp", "jlineup", "chrome-profile-" + this.id, "chrome_debug.log");
            try (Stream<String> stream = Files.lines(pathToDebugFile);){
                stream.forEach(arg_0 -> ((Logger)LOG).info(arg_0));
            }
            catch (IOException ioException) {
                LOG.error("Could not read '{}'", (Object)pathToDebugFile.toAbsolutePath(), (Object)ioException);
            }
            throw new RuntimeException(exception);
        }
        LOG.info("JLineup run finished for context '{}'", (Object)this.screenshotContext);
        MDC.remove((String)REPORT_LOG_NAME_KEY);
        return retries;
    }

    private int tryToTakeScreenshotsForContextNTimes(Browser browser, ScreenshotContext screenshotContext, int maxRetries) throws Exception {
        for (int retries = 0; retries <= maxRetries; ++retries) {
            try {
                browser.runForScreenshotContext(screenshotContext);
                return retries;
            }
            catch (Exception e) {
                if (retries >= maxRetries) {
                    LOG.error("'{}' retries did not help, giving up. Last exception was: '{}'", (Object)retries, (Object)e.getMessage());
                    throw e;
                }
                LOG.warn("try '{}' to take screen failed", (Object)retries, (Object)e);
                continue;
            }
        }
        return Integer.MAX_VALUE;
    }

    private void validateConfig() throws ValidationError {
        JobConfigValidator.validateJobConfig((JobConfig)this.jobConfig);
    }
}

