/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.lambda;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import de.otto.jlineup.GlobalOption;
import de.otto.jlineup.GlobalOptions;
import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.Utils;
import de.otto.jlineup.browser.CloudBrowser;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.lambda.LambdaRequestPayload;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.LambdaClientBuilder;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.ServiceException;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.transfer.s3.S3TransferManager;

public class LambdaBrowser
implements CloudBrowser {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final JobConfig jobConfig;
    private final RunStepConfig runStepConfig;
    private final ExecutorService executor = Executors.newCachedThreadPool(Utils.createThreadFactory((String)"LambdaBrowserSupervisorThread"));
    private final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.USE_ANNOTATIONS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).build();
    private final FileService fileService;

    public LambdaBrowser(RunStepConfig runStepConfig, JobConfig jobConfig, FileService fileService) {
        this.fileService = fileService;
        this.runStepConfig = runStepConfig;
        this.jobConfig = jobConfig;
    }

    public void takeScreenshots(List<ScreenshotContext> screenshotContexts) throws ExecutionException, InterruptedException, IOException {
        CompletableFuture download;
        String s3Bucket;
        String runId = UUID.randomUUID().toString();
        HashMap<ScreenshotContext, Future> lambdaCalls = new HashMap<ScreenshotContext, Future>();
        LOG.info("Starting {} lambda calls for run '{}'...", (Object)screenshotContexts.size(), (Object)runId);
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.create();
        try (LambdaClient lambdaClient = (LambdaClient)((LambdaClientBuilder)((LambdaClientBuilder)LambdaClient.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).region(Region.EU_CENTRAL_1)).build();){
            s3Bucket = (String)lambdaClient.getFunction((GetFunctionRequest)GetFunctionRequest.builder().functionName(GlobalOptions.getOption((GlobalOption)GlobalOption.JLINEUP_LAMBDA_FUNCTION_NAME)).build()).configuration().environment().variables().get(GlobalOption.JLINEUP_LAMBDA_S3_BUCKET.name());
            LOG.info("Using S3 bucket: {}", (Object)s3Bucket);
            for (ScreenshotContext screenshotContext : screenshotContexts) {
                Future invokeResponseFuture = this.invokeLambdaAndGetInvokeResponseFuture(screenshotContext, runId, lambdaClient);
                lambdaCalls.put(screenshotContext, invokeResponseFuture);
            }
            LOG.info("All lambda calls started, waiting for results...");
            for (Map.Entry entry : lambdaCalls.entrySet()) {
                InvokeResponse invokeResponse = (InvokeResponse)((Future)entry.getValue()).get();
                String answer = invokeResponse.payload().asUtf8String();
                String logResult = invokeResponse.logResult();
                if (logResult != null) {
                    LOG.error("Log: {}", (Object)logResult);
                }
                if (answer.contains("errorMessage")) {
                    if (answer.contains("SessionNotCreatedException") || answer.contains("disconnected: Unable to receive message from renderer")) {
                        LOG.warn("Retrying lambda call because of specific error message in answer: '{}'", (Object)answer);
                        Future invokeResponseFuture = this.invokeLambdaAndGetInvokeResponseFuture((ScreenshotContext)entry.getKey(), runId, lambdaClient);
                        InvokeResponse invokeResponseRetry = (InvokeResponse)invokeResponseFuture.get();
                        String retryAnswer = invokeResponseRetry.payload().asUtf8String();
                        if (retryAnswer.contains("errorMessage")) {
                            throw new RuntimeException("Lambda call failed even when retried: " + retryAnswer);
                        }
                        LOG.info("Answer from Lambda after retry: '{}'", (Object)retryAnswer);
                        continue;
                    }
                    throw new RuntimeException("Lambda call failed: " + answer);
                }
                LOG.info("Answer from Lambda: '{}'", (Object)answer);
            }
        }
        catch (ServiceException e) {
            LOG.error("Lambda call failed");
            throw new RuntimeException(e);
        }
        LOG.info("All lambda calls finished, starting download from S3 with transfer manager...");
        Path localFolderOfS3Content = Paths.get(this.runStepConfig.getWorkingDirectory(), this.runStepConfig.getReportDirectory(), "lambda-s3");
        try (S3TransferManager s3TransferManager = S3TransferManager.builder().s3Client(S3AsyncClient.crtBuilder().credentialsProvider((AwsCredentialsProvider)credentialsProvider).build()).build();){
            download = s3TransferManager.downloadDirectory(d -> d.bucket(s3Bucket).listObjectsV2RequestTransformer(l -> l.prefix("jlineup-" + runId)).destination(localFolderOfS3Content)).completionFuture();
        }
        LOG.info("Waiting for download to finish...");
        try {
            download.get();
        }
        catch (Exception exception) {
            LOG.error("S3 Download failed", (Throwable)exception);
            throw new RuntimeException(exception);
        }
        LOG.info("Download finished, merging context file trackers into file tracker...");
        this.fileService.mergeContextFileTrackersIntoFileTracker(localFolderOfS3Content, (d, name) -> name.startsWith("files_") && name.endsWith(".json"));
        Arrays.stream(Objects.requireNonNull(localFolderOfS3Content.toFile().listFiles())).forEach(f -> {
            try {
                if (f.isDirectory()) {
                    Arrays.stream(f.listFiles()).toList().forEach(ff -> {
                        try {
                            Files.createDirectories(Paths.get(this.runStepConfig.getWorkingDirectory(), this.runStepConfig.getScreenshotsDirectory(), f.getName()), new FileAttribute[0]);
                            Files.move(ff.toPath(), Paths.get(this.runStepConfig.getWorkingDirectory(), this.runStepConfig.getScreenshotsDirectory(), f.getName(), ff.getName()), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    f.delete();
                } else if (f.getName().endsWith(".log")) {
                    Path lambdaLogPath = Paths.get(this.runStepConfig.getWorkingDirectory(), this.runStepConfig.getReportDirectory(), "lambda.log");
                    boolean first = false;
                    if (!Files.exists(lambdaLogPath, new LinkOption[0])) {
                        Files.createFile(lambdaLogPath, new FileAttribute[0]);
                        first = true;
                    }
                    if (!first) {
                        Files.write(lambdaLogPath, "\n---\n\n".getBytes(), StandardOpenOption.APPEND);
                    }
                    Files.write(lambdaLogPath, Files.readAllBytes(f.toPath()), StandardOpenOption.APPEND);
                    f.delete();
                } else {
                    Files.move(f.toPath(), Paths.get(this.runStepConfig.getWorkingDirectory(), this.runStepConfig.getScreenshotsDirectory(), f.getName()), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        LOG.info("Merging finished, cleaning up...");
        Files.delete(localFolderOfS3Content);
        LOG.info("All done. :D");
        this.executor.shutdownNow();
    }

    private Future<InvokeResponse> invokeLambdaAndGetInvokeResponseFuture(ScreenshotContext screenshotContext, String runId, LambdaClient lambdaClient) {
        InvokeRequest invokeRequest;
        try {
            invokeRequest = (InvokeRequest)InvokeRequest.builder().functionName(GlobalOptions.getOption((GlobalOption)GlobalOption.JLINEUP_LAMBDA_FUNCTION_NAME)).payload(SdkBytes.fromUtf8String((String)this.objectMapper.writeValueAsString((Object)new LambdaRequestPayload(runId, this.jobConfig, screenshotContext, this.runStepConfig.getStep(), screenshotContext.urlKey)))).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return this.executor.submit(() -> lambdaClient.invoke(invokeRequest));
    }
}

