/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.cli;

import de.otto.jlineup.JLineupRunner;
import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.browser.Browser;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.cli.JLineup;
import de.otto.jlineup.cli.Utils;
import de.otto.jlineup.config.ConfigMerger;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.RunStep;
import de.otto.jlineup.exceptions.ValidationError;
import java.awt.Desktop;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="jlineup", sortOptions=false, modelTransformer=OptionsFilter.class)
public class JLineup
implements Callable<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @CommandLine.Option(names={"-?", "--help"}, usageHelp=true, description={"Shows this help. See https://github.com/otto-de/jlineup/blob/main/README.md for full docs."}, order=0)
    private boolean help = false;
    @CommandLine.Option(names={"-u", "--url"}, description={"If you run JLineup without config file, this is the one url that is tested with the default config."}, order=10)
    private String url = null;
    @CommandLine.Option(names={"-s", "--step"}, description={"JLineup step - 'before' just takes screenshots, 'after' takes screenshots and compares them with the 'before'-screenshots in the screenshots directory. 'compare' just compares existing screenshots, it's also included in 'after'."}, order=20)
    private RunStep step = RunStep.before;
    @CommandLine.Option(names={"-c", "--config"}, description={"The job config file which contains the url(s) and the settings for the JLineup run. See https://github.com/otto-de/jlineup/blob/main/docs/CONFIGURATION.md for all configuration options."}, order=30)
    private String configFile = "lineup.json";
    @CommandLine.Option(names={"-m", "--merge-config"}, description={"(Preview Feature) Additional config that will be merged with the given config file. Identical local values have precedence. URL keys are interpreted as regex matchers."}, order=40)
    private String mergeConfigFile = null;
    @CommandLine.Option(names={"-d", "--working-dir"}, description={"Path to the working directory"}, order=50)
    private String workingDirectory = ".";
    @CommandLine.Option(names={"-sd", "--screenshot-dir"}, description={"Screenshots directory name - relative to working directory"}, order=60)
    private String screenshotDirectory = "report/screenshots";
    @CommandLine.Option(names={"-rd", "--report-dir"}, description={"HTML report directory name - relative to working directory"}, order=70)
    private String reportDirectory = "report";
    @CommandLine.Option(names={"--print-config"}, description={"Prints the current (if found) or a default config file to standard out."}, order=80)
    private boolean printConfig = false;
    @CommandLine.Option(names={"--print-example"}, description={"Prints an example default config file to standard out. Useful as quick start."}, order=90)
    private boolean printExample = false;
    @CommandLine.Option(names={"--debug"}, description={"Sets the log level to DEBUG, produces verbose information about the current task."}, order=100)
    private boolean debug = false;
    @CommandLine.Option(names={"--log"}, description={"Sets the log level to DEBUG and logs to a file in the current working directory."}, order=110)
    private boolean logToFile = false;
    @CommandLine.Option(names={"-v", "--version"}, description={"Prints version information."}, order=120)
    private boolean version = false;
    @CommandLine.Option(names={"--chrome-parameter"}, description={"Additional command line parameters for spawned chrome processes. Example: --chrome-parameter \"--use-shm=false\""}, order=130)
    private List<String> chromeParameters;
    @CommandLine.Option(names={"--firefox-parameter"}, description={"Additional command line parameters for spawned firefox processes."}, order=140)
    private List<String> firefoxParameters;
    @CommandLine.Option(names={"-R", "--replace-in-url"}, description={"The given keys are replaced with the corresponding values in all urls that are tested."}, order=150)
    private Map<String, String> urlReplacements = new HashMap();
    @CommandLine.Option(names={"-o", "--open-report"}, description={"Opens html report after the run."}, order=160)
    private boolean openReport = false;
    @CommandLine.Option(names={"-k", "--keep-existing"}, description={"(Preview feature) Keep existing 'before' screenshots after having added new urls or paths to the config."}, order=170)
    private boolean keepExisting = false;
    @CommandLine.Option(names={"--refresh-url"}, description={"(Preview feature) Refresh 'before' screenshots for the given url only. Implicitly sets '--keep-existing' also."}, order=180)
    private String refreshUrl = null;
    @CommandLine.Option(names={"-b", "--override-browser"}, description={"(Preview feature) Override browser setting in run config."}, order=190)
    private String browserOverride = null;
    @CommandLine.Option(names={"--cleanup-profile"}, description={"Cleanup browser profile directory after the run has finished and a profile dir was specified with the browser parameters."}, order=200)
    private boolean cleanupProfile = false;

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getScreenshotDirectory() {
        return this.screenshotDirectory;
    }

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    String getConfigFile() {
        return this.configFile;
    }

    public String getMergeConfigFile() {
        return this.mergeConfigFile;
    }

    public boolean isAfter() {
        return this.step == RunStep.after;
    }

    public boolean isBefore() {
        return this.step != RunStep.after && this.step != RunStep.compare && this.step != RunStep.after_only;
    }

    public boolean isJustCompare() {
        return this.step == RunStep.compare;
    }

    public boolean isHelp() {
        return this.help;
    }

    public RunStep getStep() {
        return this.step;
    }

    public Map<String, String> getUrlReplacements() {
        return this.urlReplacements;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isPrintConfig() {
        return this.printConfig;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isLogToFile() {
        return this.logToFile;
    }

    public boolean isVersion() {
        return this.version;
    }

    public List<String> getChromeParameters() {
        return this.chromeParameters;
    }

    public List<String> getFirefoxParameters() {
        return this.firefoxParameters;
    }

    public boolean isPrintExample() {
        return this.printExample;
    }

    public boolean isOpenReport() {
        return this.openReport;
    }

    public boolean isKeepExisting() {
        return this.keepExisting;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public String getBrowserOverride() {
        return this.browserOverride;
    }

    public boolean isCleanupProfile() {
        return this.cleanupProfile;
    }

    public void setCleanupProfile(boolean cleanupProfile) {
        this.cleanupProfile = cleanupProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JLineup jLineup = (JLineup)o;
        return this.help == jLineup.help && this.printConfig == jLineup.printConfig && this.printExample == jLineup.printExample && this.debug == jLineup.debug && this.logToFile == jLineup.logToFile && this.version == jLineup.version && this.openReport == jLineup.openReport && this.keepExisting == jLineup.keepExisting && this.cleanupProfile == jLineup.cleanupProfile && Objects.equals(this.url, jLineup.url) && this.step == jLineup.step && Objects.equals(this.configFile, jLineup.configFile) && Objects.equals(this.mergeConfigFile, jLineup.mergeConfigFile) && Objects.equals(this.workingDirectory, jLineup.workingDirectory) && Objects.equals(this.screenshotDirectory, jLineup.screenshotDirectory) && Objects.equals(this.reportDirectory, jLineup.reportDirectory) && Objects.equals(this.chromeParameters, jLineup.chromeParameters) && Objects.equals(this.firefoxParameters, jLineup.firefoxParameters) && Objects.equals(this.urlReplacements, jLineup.urlReplacements) && Objects.equals(this.refreshUrl, jLineup.refreshUrl) && Objects.equals(this.browserOverride, jLineup.browserOverride);
    }

    public int hashCode() {
        return Objects.hash(this.help, this.url, this.step, this.configFile, this.mergeConfigFile, this.workingDirectory, this.screenshotDirectory, this.reportDirectory, this.printConfig, this.printExample, this.debug, this.logToFile, this.version, this.chromeParameters, this.firefoxParameters, this.urlReplacements, this.openReport, this.keepExisting, this.refreshUrl, this.browserOverride, this.cleanupProfile);
    }

    public String toString() {
        return "JLineup{help=" + this.help + ", url='" + this.url + "', step=" + this.step + ", configFile='" + this.configFile + "', mergeConfigFile='" + this.mergeConfigFile + "', workingDirectory='" + this.workingDirectory + "', screenshotDirectory='" + this.screenshotDirectory + "', reportDirectory='" + this.reportDirectory + "', printConfig=" + this.printConfig + ", printExample=" + this.printExample + ", debug=" + this.debug + ", logToFile=" + this.logToFile + ", version=" + this.version + ", chromeParameters=" + this.chromeParameters + ", firefoxParameters=" + this.firefoxParameters + ", urlReplacements=" + this.urlReplacements + ", openReport=" + this.openReport + ", keepExisting=" + this.keepExisting + ", refreshUrl='" + this.refreshUrl + "', browserOverride='" + this.browserOverride + "', cleanupProfile=" + this.cleanupProfile + "}";
    }

    @Override
    public Integer call() throws Exception {
        if (this.help) {
            CommandLine.usage((Object)new JLineup(), (PrintStream)System.out);
            LOG.info("Version: {}\n", (Object)de.otto.jlineup.Utils.getVersion());
            return -1;
        }
        if (this.version) {
            LOG.info("JLineup version {}", (Object)de.otto.jlineup.Utils.getVersion());
            return -1;
        }
        if (this.debug) {
            de.otto.jlineup.Utils.setLogLevelToDebug();
        }
        if (this.printExample) {
            System.out.println(JobConfig.prettyPrintWithAllFields((JobConfig)JobConfig.exampleConfig()));
            return 0;
        }
        if (this.getRefreshUrl() != null) {
            this.keepExisting = true;
        }
        if (this.step != RunStep.before && this.isKeepExisting()) {
            LOG.warn("The --keep-existing option is only usable in combination with the 'before' step. It is ignored for step '{}'.", (Object)this.step);
        }
        JobConfig jobConfig = null;
        try {
            jobConfig = this.buildConfig(this);
        }
        catch (IOException e) {
            LOG.error("Error building config.", (Throwable)e);
            return 1;
        }
        if (this.getMergeConfigFile() != null) {
            JobConfig mergeConfig = JobConfig.readConfig((String)this.workingDirectory, (String)this.getMergeConfigFile());
            jobConfig = ConfigMerger.mergeJobConfigWithMergeConfig((JobConfig)jobConfig, (JobConfig)mergeConfig);
        }
        if (jobConfig.mergeConfig != null) {
            JobConfig mainGlobalConfig = JobConfig.copyOfBuilder((JobConfig)jobConfig).withMergeConfig(null).build();
            JobConfig mergeGlobalConfig = jobConfig.mergeConfig;
            jobConfig = ConfigMerger.mergeJobConfigWithMergeConfig((JobConfig)mainGlobalConfig, (JobConfig)mergeGlobalConfig);
        }
        jobConfig = jobConfig.insertDefaults();
        if (this.browserOverride != null) {
            jobConfig = JobConfig.copyOfBuilder((JobConfig)jobConfig).withBrowser(Browser.Type.forValue((String)this.browserOverride)).build();
        }
        if (this.printConfig) {
            System.out.println(JobConfig.prettyPrint((JobConfig)jobConfig));
            return 0;
        }
        if (jobConfig.debug) {
            de.otto.jlineup.Utils.setLogLevelToDebug();
        }
        if (jobConfig.logToFile || this.logToFile) {
            de.otto.jlineup.Utils.logToFile((String)this.workingDirectory);
        }
        LOG.info("Running JLineup [{}] with step '{}'.\n\n", (Object)de.otto.jlineup.Utils.getVersion(), (Object)this.step);
        RunStepConfig runStepConfig = Utils.convertCommandLineParametersToRunConfiguration((JLineup)this);
        JLineupRunner jLineupRunner = null;
        try {
            jLineupRunner = new JLineupRunner(jobConfig, runStepConfig);
        }
        catch (ValidationError e) {
            LOG.error(e.getMessage());
            return 1;
        }
        try {
            boolean runSucceeded = jLineupRunner.run();
            if (this.openReport) {
                Desktop.getDesktop().browse(new URI("file://" + Paths.get(String.format("%s/%s/%s", runStepConfig.getWorkingDirectory(), runStepConfig.getReportDirectory(), "report.html"), new String[0]).toAbsolutePath()));
            }
            if (!runSucceeded) {
                return 1;
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            de.otto.jlineup.Utils.writeInfosForCommonErrors((String)e.getMessage());
            return 1;
        }
        return -1;
    }

    private JobConfig buildConfig(JLineup parameters) throws IOException {
        JobConfig jobConfig;
        if (parameters.getUrl() != null) {
            String url = BrowserUtils.prependHTTPIfNotThereAndToLowerCase((String)parameters.getUrl());
            jobConfig = JobConfig.defaultConfig((String)url);
            if (!parameters.isPrintConfig()) {
                LOG.info("You specified an explicit URL parameter ({}), any given jobConfig file is ignored! This should only be done for testing purposes.", (Object)url);
                LOG.info("Using generated jobConfig:\n\n{}", (Object)JobConfig.prettyPrint((JobConfig)jobConfig));
                LOG.info("\nYou can take this generated jobConfig as base and save it as a text file named 'lineup.json'.");
                LOG.info("Just add --print-config parameter to let JLineup print a more detailed example jobConfig");
            }
        } else {
            try {
                jobConfig = Utils.readConfig((JLineup)parameters);
            }
            catch (Exception e) {
                if (!parameters.isPrintConfig()) {
                    LOG.error(e.getMessage());
                    LOG.error("Use --help to see the JLineup quick help.");
                    throw e;
                }
                return JobConfig.exampleConfig();
            }
        }
        return jobConfig;
    }
}

