/*
 * Decompiled with CFR 0.152.
 */
package de.otto.hmac.authentication.jersey2.filter;

import com.google.common.io.ByteSource;
import de.otto.hmac.authentication.WrappedOutputStream;
import de.otto.hmac.authentication.WrappedOutputStreamContext;
import de.otto.hmac.authentication.jersey2.filter.Jersey2WrappedOutputStreamContext;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import org.joda.time.Instant;

public class HmacJersey2ClientRequestFilter
implements ClientRequestFilter {
    private String user;
    private String secretKey;

    public HmacJersey2ClientRequestFilter(String user, String secretKey) {
        this.user = user;
        this.secretKey = secretKey;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        Jersey2WrappedOutputStreamContext wrappedOutputStreamContext = new Jersey2WrappedOutputStreamContext(requestContext);
        if (requestContext.hasEntity()) {
            requestContext.setEntityStream((OutputStream)new WrappedOutputStream(this.user, this.secretKey, (WrappedOutputStreamContext)wrappedOutputStreamContext, requestContext.getEntityStream()));
        } else {
            WrappedOutputStream.addHmacHttpRequestHeaders((WrappedOutputStreamContext)wrappedOutputStreamContext, (String)this.user, (String)this.secretKey, (Instant)new Instant(), (ByteSource)ByteSource.empty());
        }
    }
}

