/*
 * Decompiled with CFR 0.152.
 */
package de.otto.hmac.authentication;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.FileBackedOutputStream;
import de.otto.hmac.HmacAttributes;
import de.otto.hmac.authentication.RequestSigningUtil;
import de.otto.hmac.authentication.WrappedOutputStreamContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Clock;
import java.time.Instant;

public class WrappedOutputStream
extends OutputStream {
    private final OutputStream out;
    private final FileBackedOutputStream tmpOut;
    private final WrappedOutputStreamContext cr;
    private final String user;
    private final String secretKey;
    private final Clock clock;

    public WrappedOutputStream(String user, String secretKey, WrappedOutputStreamContext cr, OutputStream out, Clock clock) {
        this.out = out;
        this.tmpOut = new FileBackedOutputStream(10000000);
        this.cr = cr;
        this.user = user;
        this.secretKey = secretKey;
        this.clock = clock;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.tmpOut.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.tmpOut.write(b);
    }

    @Override
    public void write(int b) throws IOException {
        this.tmpOut.write(b);
    }

    @Override
    public void close() throws IOException {
        WrappedOutputStream.addHmacHttpRequestHeaders(this.cr, this.user, this.secretKey, Instant.now(this.clock), this.tmpOut.asByteSource());
        if (this.tmpOut.asByteSource().isEmpty()) {
            this.out.write("".getBytes(), 0, 0);
        }
        try (InputStream in = this.tmpOut.asByteSource().openBufferedStream();){
            ByteStreams.copy((InputStream)in, (OutputStream)this.out);
        }
        this.tmpOut.close();
        this.out.close();
    }

    public static void addHmacHttpRequestHeaders(WrappedOutputStreamContext cr, String user, String secretKey, Instant now, ByteSource body) {
        String signatureHeader = user + ":" + RequestSigningUtil.createRequestSignature(cr.getMethod(), now.toString(), cr.getRequestUri(), body, secretKey);
        cr.putSingle(HmacAttributes.X_HMAC_AUTH_SIGNATURE, signatureHeader);
        cr.putSingle(HmacAttributes.X_HMAC_AUTH_DATE, now.toString());
    }
}

