/*
 * Decompiled with CFR 0.152.
 */
package de.otto.hmac.authentication;

import com.google.common.base.Strings;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import de.otto.hmac.HmacAttributes;
import de.otto.hmac.authentication.WrappedRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSigningUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSigningUtil.class);

    public static boolean checkRequest(WrappedRequest request, String secretKey, Clock clock) {
        if (!RequestSigningUtil.hasValidRequestTimeStamp(request, clock)) {
            return false;
        }
        String requestSignature = RequestSigningUtil.getSignature((HttpServletRequest)request);
        String[] split = requestSignature.split(":");
        String sentSignature = split[1];
        String generatedSignature = RequestSigningUtil.createRequestSignature(request, secretKey);
        return generatedSignature.equals(sentSignature);
    }

    public static boolean hasValidRequestTimeStamp(WrappedRequest request, Clock clock) {
        Duration fiveMinutes;
        boolean inRange;
        String requestTimeString = RequestSigningUtil.getDateFromHeader((HttpServletRequest)request);
        if (requestTimeString.isEmpty()) {
            LOG.error("Signierter Request enth\u00c3\u00a4lt kein Datum.");
            return false;
        }
        Instant serverTime = Instant.now(clock);
        Instant requestTime = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)requestTimeString, Instant::from);
        boolean bl = inRange = requestTime.isAfter(serverTime.minus(fiveMinutes = Duration.ofMinutes(5L))) && requestTime.isBefore(serverTime.plus(fiveMinutes));
        if (!inRange) {
            LOG.warn("Zeitstempel ausserhalb Serverzeit. Server: " + serverTime + ". Request: " + requestTimeString + ".");
        }
        return inRange;
    }

    public static String createSignatureBase(WrappedRequest request) {
        return RequestSigningUtil.createSignatureBase(request.getMethod(), RequestSigningUtil.getDateFromHeader((HttpServletRequest)request), request.getRequestURI(), request.getBody());
    }

    public static String createSignatureBase(String method, String dateHeader, String requestUri, ByteSource body) {
        String decodedRequestUri;
        try {
            decodedRequestUri = URLDecoder.decode(requestUri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Could not decode requestUri");
            decodedRequestUri = requestUri;
        }
        return method + "\n" + dateHeader + "\n" + decodedRequestUri + "\n" + RequestSigningUtil.toMd5Hex(body);
    }

    public static String createRequestSignature(String method, String dateHeader, String requestUri, ByteSource body, String secretKey) {
        String signatureBase = RequestSigningUtil.createSignatureBase(method, dateHeader, requestUri, body);
        return RequestSigningUtil.createRequestSignature(signatureBase, secretKey);
    }

    public static String createRequestSignature(String signatureBase, String secretKey) {
        if (Strings.isNullOrEmpty((String)secretKey)) {
            throw new IllegalArgumentException("Secret Key provided to HMAC SigningUtils was null or empty.");
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(keySpec);
            byte[] result = mac.doFinal(signatureBase.getBytes(StandardCharsets.UTF_8));
            return RequestSigningUtil.encodeBase64WithoutLinefeed(result);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException("should never happen", e);
        }
    }

    public static String createRequestSignature(WrappedRequest request, String secretKey) {
        String signatureBase = RequestSigningUtil.createSignatureBase(request);
        return RequestSigningUtil.createRequestSignature(signatureBase, secretKey);
    }

    protected static String encodeBase64WithoutLinefeed(byte[] result) {
        return Base64.encodeBase64String((byte[])result).trim();
    }

    public static boolean hasSignature(HttpServletRequest request) {
        return request.getHeader(HmacAttributes.X_HMAC_AUTH_SIGNATURE) != null;
    }

    public static String getSignature(HttpServletRequest request) {
        return request.getHeader(HmacAttributes.X_HMAC_AUTH_SIGNATURE);
    }

    public static String getDateFromHeader(HttpServletRequest request) {
        String header = request.getHeader(HmacAttributes.X_HMAC_AUTH_DATE);
        if (header == null) {
            return "";
        }
        return header;
    }

    public static String toMd5Hex(ByteSource byteSource) {
        try {
            HashCode md5 = byteSource.hash(Hashing.md5());
            return md5.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("error evaluating md5 sum", e);
        }
    }
}

