/*
 * Decompiled with CFR 0.152.
 */
package de.otto.hmac.authentication;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.FileBackedOutputStream;
import de.otto.hmac.authentication.WrappedServletInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class WrappedRequest
extends HttpServletRequestWrapper
implements AutoCloseable {
    private FileBackedOutputStream body = new FileBackedOutputStream(10000000, true);

    public static WrappedRequest wrap(HttpServletRequest request) throws IOException {
        if (request instanceof WrappedRequest) {
            return (WrappedRequest)request;
        }
        return new WrappedRequest(request);
    }

    public ServletInputStream getInputStream() throws IOException {
        return new WrappedServletInputStream(this.getBody().openBufferedStream());
    }

    public ByteSource getBody() {
        return this.body.asByteSource();
    }

    private WrappedRequest(HttpServletRequest request) throws IOException {
        super(request);
        if (request.getInputStream() != null) {
            try (ServletInputStream inputStream = request.getInputStream();){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)this.body);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.body.close();
    }
}

