/*
 * Decompiled with CFR 0.152.
 */
package de.otto.hmac.authentication;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import de.otto.hmac.HmacAttributes;
import de.otto.hmac.authentication.WrappedRequest;
import java.io.IOException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSigningUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSigningUtil.class);

    public static boolean checkRequest(WrappedRequest request, String secretKey) {
        if (!RequestSigningUtil.hasValidRequestTimeStamp(request)) {
            return false;
        }
        String requestSignature = RequestSigningUtil.getSignature((HttpServletRequest)request);
        String[] split = requestSignature.split(":");
        String sentSignature = split[1];
        String generatedSignature = RequestSigningUtil.createRequestSignature(request, secretKey);
        return generatedSignature.equals(sentSignature);
    }

    public static boolean hasValidRequestTimeStamp(WrappedRequest request) {
        boolean inRange;
        String requestTimeString = RequestSigningUtil.getDateFromHeader((HttpServletRequest)request);
        if (requestTimeString == null || requestTimeString.isEmpty()) {
            LOG.error("Signierter Request enth\u00e4lt kein Datum.");
            return false;
        }
        Instant serverTime = new Instant();
        Instant requestTime = new Instant((Object)requestTimeString);
        long fiveMinutes = 300000L;
        boolean bl = inRange = requestTime.isAfter((ReadableInstant)serverTime.minus(300000L)) && requestTime.isBefore((ReadableInstant)serverTime.plus(300000L));
        if (!inRange) {
            LOG.warn("Zeitstempel ausserhalb Serverzeit. Server: " + serverTime + ". Request: " + requestTimeString + ".");
        }
        return inRange;
    }

    public static String createSignatureBase(WrappedRequest request) {
        return RequestSigningUtil.createSignatureBase(request.getMethod(), RequestSigningUtil.getDateFromHeader((HttpServletRequest)request), request.getRequestURI(), request.getBody());
    }

    public static String createSignatureBase(String method, String dateHeader, String requestUri, ByteSource body) {
        StringBuilder builder = new StringBuilder();
        builder.append(method).append("\n");
        builder.append(dateHeader).append("\n");
        builder.append(requestUri).append("\n");
        builder.append(RequestSigningUtil.toMd5Hex(body));
        return builder.toString();
    }

    public static String createRequestSignature(String method, String dateHeader, String requestUri, ByteSource body, String secretKey) {
        String signatureBase = RequestSigningUtil.createSignatureBase(method, dateHeader, requestUri, body);
        return RequestSigningUtil.createRequestSignature(signatureBase, secretKey);
    }

    public static String createRequestSignature(String signatureBase, String secretKey) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(secretKey.getBytes(), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(keySpec);
            byte[] result = mac.doFinal(signatureBase.getBytes());
            return RequestSigningUtil.encodeBase64WithoutLinefeed(result);
        }
        catch (Exception e) {
            throw new RuntimeException("should never happen", e);
        }
    }

    public static String createRequestSignature(WrappedRequest request, String secretKey) {
        String signatureBase = RequestSigningUtil.createSignatureBase(request);
        return RequestSigningUtil.createRequestSignature(signatureBase, secretKey);
    }

    protected static String encodeBase64WithoutLinefeed(byte[] result) {
        return Base64.encodeBase64String((byte[])result).trim();
    }

    public static boolean hasSignature(HttpServletRequest request) {
        return request.getHeader(HmacAttributes.X_HMAC_AUTH_SIGNATURE) != null;
    }

    public static String getSignature(HttpServletRequest request) {
        return request.getHeader(HmacAttributes.X_HMAC_AUTH_SIGNATURE);
    }

    public static String getDateFromHeader(HttpServletRequest request) {
        String header = request.getHeader(HmacAttributes.X_HMAC_AUTH_DATE);
        if (header == null) {
            return "";
        }
        return header;
    }

    public static String toMd5Hex(ByteSource byteSource) {
        try {
            HashCode md5 = byteSource.hash(Hashing.md5());
            return md5.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("error evaluating md5 sum", e);
        }
    }
}

