/*
 * Decompiled with CFR 0.152.
 */
package de.otto.hmac.authentication;

import de.otto.hmac.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class WrappedRequest
extends HttpServletRequestWrapper {
    private final String body;

    public static WrappedRequest wrap(HttpServletRequest request) throws IOException {
        if (request instanceof WrappedRequest) {
            return (WrappedRequest)request;
        }
        return new WrappedRequest(request);
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){
            final ByteArrayInputStream inputStream;
            {
                this.inputStream = new ByteArrayInputStream(WrappedRequest.this.body.getBytes());
            }

            public int read() throws IOException {
                return this.inputStream.read();
            }
        };
    }

    public String getBody() {
        return this.body;
    }

    private WrappedRequest(HttpServletRequest request) throws IOException {
        super(request);
        String result;
        try (ServletInputStream inputStream = request.getInputStream();){
            result = inputStream != null ? StringUtils.toString((InputStream)inputStream) : "";
        }
        this.body = result;
    }
}

