/*
 * Decompiled with CFR 0.152.
 */
package de.otto.hmac.authentication;

import de.otto.hmac.HmacAttributes;
import de.otto.hmac.authentication.WrappedRequest;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSigningUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSigningUtil.class);

    public static boolean checkRequest(WrappedRequest request, String secretKey) {
        if (!RequestSigningUtil.hasValidRequestTimeStamp(request)) {
            return false;
        }
        String requestSignature = request.getHeader(HmacAttributes.X_HMAC_AUTH_SIGNATURE);
        String[] split = requestSignature.split(":");
        String sentSignature = split[1];
        String generatedSignature = RequestSigningUtil.createRequestSignature(request, secretKey);
        return generatedSignature.equals(sentSignature);
    }

    public static boolean hasValidRequestTimeStamp(WrappedRequest request) {
        boolean inRange;
        String requestTimeString = RequestSigningUtil.getDateFromHeader((HttpServletRequest)request);
        if (requestTimeString == null || requestTimeString.isEmpty()) {
            LOG.error("Signierter Request enth\u00e4lt kein Datum.");
            return false;
        }
        Instant serverTime = new Instant();
        Instant requestTime = new Instant((Object)requestTimeString);
        long fiveMinutes = 300000L;
        boolean bl = inRange = requestTime.isAfter((ReadableInstant)serverTime.minus(300000L)) && requestTime.isBefore((ReadableInstant)serverTime.plus(300000L));
        if (!inRange) {
            LOG.warn("Zeitstempel ausserhalb Serverzeit. Server: " + serverTime + ". Request: " + requestTimeString + ".");
        }
        return inRange;
    }

    public static String createSignatureBase(WrappedRequest request) {
        return RequestSigningUtil.createSignatureBase(request.getMethod(), request.getHeader(HmacAttributes.X_HMAC_AUTH_DATE), request.getRequestURI(), request.getBody());
    }

    public static String createSignatureBase(String method, String dateHeader, String requestUri, String body) {
        StringBuilder builder = new StringBuilder();
        builder.append(method).append("\n");
        builder.append(dateHeader).append("\n");
        builder.append(requestUri).append("\n");
        builder.append(RequestSigningUtil.toMd5(body));
        return builder.toString();
    }

    public static String createRequestSignature(String method, String dateHeader, String requestUri, String body, String secretKey) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(secretKey.getBytes(), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(keySpec);
            String signatureBase = RequestSigningUtil.createSignatureBase(method, dateHeader, requestUri, body);
            byte[] result = mac.doFinal(signatureBase.getBytes());
            return Base64.encodeBase64String((byte[])result);
        }
        catch (Exception e) {
            throw new RuntimeException("should never happen", e);
        }
    }

    public static String createRequestSignature(WrappedRequest request, String secretKey) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(secretKey.getBytes(), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(keySpec);
            String signatureBase = RequestSigningUtil.createSignatureBase(request);
            byte[] result = mac.doFinal(signatureBase.getBytes());
            return Base64.encodeBase64String((byte[])result);
        }
        catch (Exception e) {
            throw new RuntimeException("should never happen", e);
        }
    }

    private static String toMd5(String body) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return Hex.encodeHexString((byte[])md.digest(body.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException("should never happen", e);
        }
    }

    public static boolean hasSignature(HttpServletRequest request) {
        return request.getHeader(HmacAttributes.X_HMAC_AUTH_SIGNATURE) != null;
    }

    public static String getSignature(HttpServletRequest request) {
        return request.getHeader(HmacAttributes.X_HMAC_AUTH_SIGNATURE);
    }

    public static String getDateFromHeader(HttpServletRequest request) {
        String header = request.getHeader(HmacAttributes.X_HMAC_AUTH_DATE);
        if (header == null) {
            return "";
        }
        return header;
    }
}

