package de.otto.eventsourcing.testsupport;

import org.slf4j.Logger;
import org.springframework.util.concurrent.ListenableFutureCallback;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import static java.lang.String.format;
import static org.slf4j.LoggerFactory.getLogger;

public class LatchedCallback<T> implements ListenableFutureCallback<T> {
    private static final Logger LOG = getLogger(LatchedCallback.class);
    private final CountDownLatch latch;
    private volatile T lastEvent;

    public LatchedCallback() {
        latch = new CountDownLatch(1);
    }

    public LatchedCallback(final int count) {
        latch = new CountDownLatch(count);
    }

    @Override
    public void onFailure(Throwable ex) {
        LOG.debug("received onFailure {}", ex.getMessage());
    }

    @Override
    public void onSuccess(T result) {
        LOG.trace("Received onSuccess {}", result);
        lastEvent = result;
        latch.countDown();
    }

    public T await(final int timeout, final TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        LOG.trace("Waiting for latch...");
        if (latch.await(timeout, timeUnit)) {
            LOG.trace("...got it. Returning with {}", lastEvent);
            return lastEvent;
        } else {
            throw new TimeoutException(format("Did no receive onSuccess within %s%s", timeout, timeUnit));
        }
    }

}
