package de.otto.eventsourcing.testsupport;

import com.github.charithe.kafka.EphemeralKafkaBroker;
import com.github.charithe.kafka.KafkaHelper;
import com.google.common.util.concurrent.Futures;
import org.slf4j.Logger;

import static org.slf4j.LoggerFactory.getLogger;

public final class EmbeddedKafkaServer {

    private static final Logger LOG = getLogger(EmbeddedKafkaServer.class);
    private static volatile EphemeralKafkaBroker broker = null;

    public static synchronized void init(final int kafkaPort) {
        if (broker == null) {
            try {
                LOG.info("Starting embedded Kafka broker...");
                broker = EphemeralKafkaBroker.create(kafkaPort, 9043);
                Futures.getUnchecked(broker.start());
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    synchronized (EmbeddedKafkaServer.class) {
                        LOG.info("Stopping embedded Kafka broker...");
                        if (broker != null) {
                            broker.stop();
                        }
                        LOG.info("...done.");
                    }
                }));
                LOG.info("...done.");
            } catch (final Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public static EphemeralKafkaBroker kafkaBroker() throws Exception {
        if (broker == null) {
            init(9042);
        }
        return broker;
    }

    public static synchronized KafkaHelper kafkaHelper() {
        if (broker == null) {
            init(9042);
        }
        return KafkaHelper.createFor(broker);
    }


}
