/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.monitor;

import de.otto.eventsourcing.event.Key;
import de.otto.eventsourcing.event.Payload;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.context.ApplicationEvent;

public final class TopicUpdateEvent
extends ApplicationEvent {
    private final String topic;
    private final int partition;
    private final long offset;

    public TopicUpdateEvent(ConsumerRecord<Key, Payload> consumerRecord) {
        this(consumerRecord.topic(), consumerRecord.partition(), consumerRecord.offset());
    }

    public TopicUpdateEvent(String topic, int partition, long offset) {
        super((Object)topic);
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TopicUpdateEvent that = (TopicUpdateEvent)((Object)o);
        return this.partition == that.partition && this.offset == that.offset && Objects.equals(this.topic, that.topic);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.partition, this.offset);
    }

    public String toString() {
        return "TopicUpdateEvent{topic='" + this.topic + '\'' + ", partition=" + this.partition + ", offset=" + this.offset + '}';
    }
}

