/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.event;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;

public class Key {
    @NotBlank
    private String entityId;
    @NotEmpty
    private SortedMap<String, String> parts = new TreeMap<String, String>();

    Key() {
        this.entityId = "";
    }

    private Key(String entityId, String k1, String v1, String ... more) {
        List<String> keyValues = Arrays.asList(more);
        if (keyValues.size() % 2 != 0) {
            throw new IllegalArgumentException("number of key-values must be even");
        }
        this.entityId = entityId;
        this.parts.put(k1, v1);
        for (int i = 0; i < keyValues.size() / 2; ++i) {
            this.parts.put(keyValues.get(2 * i), keyValues.get(2 * i + 1));
        }
    }

    private Key(String entityId, Map<String, String> parts) {
        this.entityId = entityId;
        this.parts.putAll(parts);
    }

    public static Key of(String entityId) {
        return new Key(entityId, Collections.emptyMap());
    }

    public static Key of(String entityId, String key, String value) {
        return new Key(entityId, key, value, new String[0]);
    }

    public static Key of(String entityId, String k1, String v1, String ... more) {
        return new Key(entityId, k1, v1, more);
    }

    public static Key of(String entityId, Map<String, String> parts) {
        return new Key(entityId, parts);
    }

    @JsonIgnore
    public boolean isComplex() {
        return this.parts.size() > 0;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @JsonAnyGetter
    public Map<String, String> getParts() {
        return this.parts;
    }

    @JsonAnySetter
    public void setParts(String key, String value) {
        this.parts.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key1 = (Key)o;
        return Objects.equals(this.entityId, key1.entityId) && Objects.equals(this.parts, key1.parts);
    }

    public int hashCode() {
        return Objects.hash(this.entityId, this.parts);
    }

    public String toString() {
        return "{entityId='" + this.entityId + '\'' + ", parts=" + this.parts + '}';
    }
}

