/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.configuration;

import de.otto.eventsourcing.configuration.EventsourcingProperties;
import de.otto.eventsourcing.monitor.TopicsMonitor;
import java.util.Properties;
import kafka.admin.AdminClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ConditionalOnProperty(prefix="eventsourcing.topics-monitor", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableScheduling
@EnableConfigurationProperties(value={KafkaProperties.class, EventsourcingProperties.class})
public class TopicsMonitorConfiguration {
    private static final long DEFAULT_ACCEPTED_LAG = 5L;

    @Bean
    @ConditionalOnMissingBean(value={AdminClient.class})
    public AdminClient adminClient(KafkaProperties kafkaProperties) {
        Properties config = new Properties();
        config.put("bootstrap.servers", kafkaProperties.getBootstrapServers().get(0));
        return AdminClient.create((Properties)config);
    }

    @Bean
    @ConditionalOnMissingBean(value={TopicsMonitor.class})
    public TopicsMonitor topicsMonitor(AdminClient adminClient) {
        return new TopicsMonitor(adminClient, 5L);
    }
}

