/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.eventsourcing.event.Key;
import de.otto.eventsourcing.event.Payload;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.LoggingProducerListener;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.kafka.support.serializer.JsonSerializer;

@EnableConfigurationProperties(value={KafkaProperties.class})
@Configuration
public class KafkaProducerConfiguration {
    @Bean
    public ProducerFactory<Key, Payload> eventProducerFactory(Serializer<Key> keySerializer, Serializer<Payload> payloadSerializer, KafkaProperties kafkaProperties) {
        return new DefaultKafkaProducerFactory(kafkaProperties.buildProducerProperties(), keySerializer, payloadSerializer);
    }

    @Bean
    public ProducerListener<Key, Payload> eventProducerListener() {
        return new LoggingProducerListener();
    }

    @Bean
    public KafkaTemplate<Key, Payload> eventKafkaTemplate(ProducerFactory<Key, Payload> eventProducerFactory, ProducerListener<Key, Payload> eventProducerListener, KafkaProperties kafkaProperties) {
        KafkaTemplate kafkaTemplate = new KafkaTemplate(eventProducerFactory);
        kafkaTemplate.setDefaultTopic(kafkaProperties.getTemplate().getDefaultTopic());
        kafkaTemplate.setProducerListener(eventProducerListener);
        return kafkaTemplate;
    }

    @Bean
    public Serializer<Key> keySerializer(ObjectMapper objectMapper) {
        return new JsonSerializer(objectMapper);
    }

    @Bean
    public Serializer<Payload> payloadSerializer(ObjectMapper objectMapper) {
        return new JsonSerializer(objectMapper);
    }
}

