/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.configuration;

import de.otto.eventsourcing.event.Key;
import de.otto.eventsourcing.event.Payload;
import de.otto.eventsourcing.monitor.TopicsMonitor;
import de.otto.eventsourcing.query.EventsourcingConsumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.kafka.core.ConsumerFactory;

public class EventsourcingConsumerFactory
implements ConsumerFactory<Key, Payload> {
    private final Map<String, Object> configs;
    private Deserializer<Key> keyDeserializer;
    private Deserializer<Payload> valueDeserializer;
    private Optional<TopicsMonitor> topicsMonitor;

    public EventsourcingConsumerFactory(Map<String, Object> configs, Deserializer<Key> keyDeserializer, Deserializer<Payload> valueDeserializer, Optional<TopicsMonitor> topicsMonitor) {
        this.configs = new HashMap<String, Object>(configs);
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.topicsMonitor = topicsMonitor;
    }

    public Map<String, Object> getConfigurationProperties() {
        return Collections.unmodifiableMap(this.configs);
    }

    public EventsourcingConsumer createConsumer() {
        return this.createKafkaConsumer();
    }

    protected EventsourcingConsumer createKafkaConsumer() {
        return this.createKafkaConsumer(this.configs);
    }

    protected EventsourcingConsumer createKafkaConsumer(String clientIdSuffix) {
        if (!this.configs.containsKey("client.id") || clientIdSuffix == null) {
            return this.createKafkaConsumer();
        }
        HashMap<String, Object> modifiedClientIdConfigs = new HashMap<String, Object>(this.configs);
        modifiedClientIdConfigs.put("client.id", modifiedClientIdConfigs.get("client.id") + clientIdSuffix);
        return this.createKafkaConsumer(modifiedClientIdConfigs);
    }

    protected EventsourcingConsumer createKafkaConsumer(Map<String, Object> configs) {
        String groupId = UUID.randomUUID().toString();
        HashMap<String, Object> configsWithGroup = new HashMap<String, Object>(configs);
        configsWithGroup.put("group.id", groupId);
        this.topicsMonitor.ifPresent(monitor -> monitor.registerGroupId(groupId));
        return new EventsourcingConsumer(configsWithGroup, this.keyDeserializer, this.valueDeserializer);
    }

    public boolean isAutoCommit() {
        Object auto = this.configs.get("enable.auto.commit");
        return auto instanceof Boolean ? (Boolean)auto : (auto instanceof String ? Boolean.valueOf((String)auto) : true);
    }
}

