/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.command;

import de.otto.eventsourcing.command.Command;
import de.otto.eventsourcing.command.CommandFactory;
import de.otto.eventsourcing.event.Key;
import de.otto.eventsourcing.event.Payload;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class SimpleCommandFactory<T>
implements CommandFactory<T> {
    private final String topic;
    private final Function<T, Key> keyMapper;
    private final Function<T, Payload> payloadMapper;

    public SimpleCommandFactory(String topic, Function<T, Key> keyMapper, Function<T, Payload> payloadMapper) {
        this.topic = topic;
        this.keyMapper = keyMapper;
        this.payloadMapper = payloadMapper;
    }

    @Override
    public List<Command> putEventsFor(T entity) {
        return Collections.singletonList(new Command(this.topic, this.keyMapper.apply(entity), this.payloadMapper.apply(entity)));
    }

    @Override
    public List<Command> deleteEventsFor(String entityId) {
        return Collections.singletonList(new Command(this.topic, entityId, null));
    }
}

