/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.command;

import de.otto.eventsourcing.command.Command;
import de.otto.eventsourcing.command.CommandFactory;
import de.otto.eventsourcing.event.Key;
import de.otto.eventsourcing.event.Payload;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.messaging.support.MessageBuilder;

public class CommandService<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CommandService.class);
    private final KafkaTemplate<Key, Payload> kafka;
    private final CommandFactory<T> commandFactory;

    public CommandService(KafkaTemplate<Key, Payload> eventKafkaTemplate, CommandFactory<T> commandFactory) {
        this.kafka = eventKafkaTemplate;
        this.commandFactory = commandFactory;
    }

    protected void send(List<Command> commands) {
        commands.forEach(this::send);
    }

    protected void send(Command command) {
        LOG.info("Sending event='{}'", (Object)command);
        if (command.getPayload() == null) {
            this.kafka.send(MessageBuilder.withPayload((Object)KafkaNull.INSTANCE).setHeader("kafka_messageKey", (Object)command.getKey()).setHeader("kafka_topic", (Object)command.getTopic()).build());
        } else {
            this.kafka.send(MessageBuilder.withPayload((Object)command.getPayload()).setHeader("kafka_messageKey", (Object)command.getKey()).setHeader("kafka_topic", (Object)command.getTopic()).build());
        }
    }

    public void put(T entity) {
        this.send(this.commandFactory.putEventsFor(entity));
    }

    public void patch(T entity) {
        this.send(this.commandFactory.patchEventsFor(entity));
    }

    public void delete(String entityId) {
        this.send(this.commandFactory.deleteEventsFor(entityId));
    }
}

