/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.command;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.otto.eventsourcing.event.Key;
import de.otto.eventsourcing.event.Payload;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Command {
    @JsonProperty
    private String topic;
    @JsonProperty
    private Key key;
    @JsonProperty
    private Payload payload;

    Command() {
        this.topic = null;
        this.key = null;
        this.payload = null;
    }

    public Command(String topic, String entityId, Payload payload) {
        this(topic, Key.of(entityId), payload);
    }

    public Command(String topic, Key key, Payload payload) {
        this.topic = Objects.requireNonNull(topic);
        this.key = Objects.requireNonNull(key);
        this.payload = payload;
    }

    public String getTopic() {
        return this.topic;
    }

    public Key getKey() {
        return this.key;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command command = (Command)o;
        return Objects.equals(this.topic, command.topic) && Objects.equals(this.key, command.key) && Objects.equals(this.payload, command.payload);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.key, this.payload);
    }

    public String toString() {
        return "Event{topic='" + this.topic + '\'' + ", key=" + this.key + ", payload=" + this.payload + '}';
    }
}

