package de.otto.eventsourcing.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.eventsourcing.event.Key;
import de.otto.eventsourcing.event.Payload;
import org.apache.kafka.clients.consumer.ConsumerRecord;

import java.util.Optional;

public class SimpleEventProcessor<T> implements EventProcessor<T> {

    private final ObjectMapper objectMapper;
    private final Class<T> targetType;

    public SimpleEventProcessor(final ObjectMapper objectMapper, final Class<T> type) {
        this.objectMapper = objectMapper;
        this.targetType = type;
    }

    @Override
    public T process(final ConsumerRecord<Key, Payload> event, final Optional<T> existing) {
        return objectMapper.convertValue(event.value(), targetType);
    }

}
