package de.otto.eventsourcing.query;

import de.otto.eventsourcing.event.Key;
import de.otto.eventsourcing.event.Payload;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;

import java.util.Map;

public class EventsourcingConsumer extends KafkaConsumer<Key, Payload> {

    private final String groupId;

    /**
     * A consumer is instantiated by providing a set of key-value pairs as configuration, and a key and a value {@link Deserializer}.
     * <p>
     * Valid configuration strings are documented at {@link ConsumerConfig}
     *
     * @param configs           The consumer configs
     * @param keyDeserializer   The deserializer for key that implements {@link Deserializer}. The configure() method
     *                          won't be called in the consumer when the deserializer is passed in directly.
     * @param valueDeserializer The deserializer for value that implements {@link Deserializer}. The configure() method
     */
    public EventsourcingConsumer(final Map<String, Object> configs,
                                 final Deserializer<Key> keyDeserializer,
                                 final Deserializer<Payload> valueDeserializer) {
        super(configs, keyDeserializer, valueDeserializer);
        this.groupId = configs.get(ConsumerConfig.GROUP_ID_CONFIG).toString();
    }

    public String getGroupId() {
        return this.groupId;
    }

}
