package de.otto.eventsourcing.monitor;

import de.otto.eventsourcing.event.Key;
import de.otto.eventsourcing.event.Payload;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.context.ApplicationEvent;

import java.util.Objects;

public final class TopicUpdateEvent extends ApplicationEvent {

    private final String topic;
    private final int partition;
    private final long offset;

    public TopicUpdateEvent(final ConsumerRecord<Key, Payload> consumerRecord) {
        this(consumerRecord.topic(), consumerRecord.partition(), consumerRecord.offset());
    }

    public TopicUpdateEvent(final String topic,
                            final int partition,
                            final long offset) {
        super(topic);
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
    }

    public String getTopic() {
        return topic;
    }

    public int getPartition() {
        return partition;
    }

    public long getOffset() {
        return offset;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TopicUpdateEvent that = (TopicUpdateEvent) o;
        return partition == that.partition &&
                offset == that.offset &&
                Objects.equals(topic, that.topic);
    }

    @Override
    public int hashCode() {
        return Objects.hash(topic, partition, offset);
    }

    @Override
    public String toString() {
        return "TopicUpdateEvent{" +
                "topic='" + topic + '\'' +
                ", partition=" + partition +
                ", offset=" + offset +
                '}';
    }
}
