package de.otto.eventsourcing.event;

import java.util.*;

import static java.util.Collections.singletonMap;

public class Payload extends TreeMap<String, Object> {

    private Payload() {
    }

    private Payload(Map<? extends String, ?> m) {
        super(m);
    }

    public static Payload of(final String k, Object v) {
        return new Payload(singletonMap(k, v));
    }

    public static Payload of(final Map<String, ?> payload) {
        return new Payload(payload);
    }
}
