package de.otto.eventsourcing.configuration;

import de.otto.eventsourcing.monitor.TopicsMonitor;
import kafka.admin.AdminClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

import java.util.Properties;

import static kafka.admin.AdminClient.create;

@Configuration
@ConditionalOnProperty(prefix = "eventsourcing.topics-monitor", name = "enabled", havingValue = "true", matchIfMissing = false)
@EnableScheduling
@EnableConfigurationProperties({
        KafkaProperties.class,
        EventsourcingProperties.class
})
public class TopicsMonitorConfiguration {

    private static final long DEFAULT_ACCEPTED_LAG = 5L;

    @Bean
    @ConditionalOnMissingBean(AdminClient.class)
    public AdminClient adminClient(final KafkaProperties kafkaProperties) {
        final Properties config = new Properties();
        config.put("bootstrap.servers", kafkaProperties.getBootstrapServers().get(0));
        return create(config);
    }

    @Bean
    @ConditionalOnMissingBean(TopicsMonitor.class)
    @SuppressWarnings("SpringJavaAutowiringInspection")
    public TopicsMonitor topicsMonitor(final AdminClient adminClient) {
        return new TopicsMonitor(adminClient, DEFAULT_ACCEPTED_LAG);
    }

}
