package de.otto.eventsourcing.configuration;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import java.util.Map;

@Validated
@ConfigurationProperties(prefix = "eventsourcing")
public class EventsourcingProperties {

    @NotNull
    private TopicsMonitor topicsMonitor = new TopicsMonitor();

    private Map<String, String> topics;

    public TopicsMonitor getTopicsMonitor() {
        return topicsMonitor;
    }

    public void setTopicsMonitor(TopicsMonitor topicsMonitor) {
        this.topicsMonitor = topicsMonitor;
    }

    public Map<String, String> getTopics() {
        return topics;
    }

    public void setTopics(Map<String, String> topics) {
        this.topics = topics;
    }

    public static class TopicsMonitor {
        private boolean enabled = false;
        @DecimalMin("0")
        private String initialDelay = "500";
        @DecimalMin("500")
        private String fetchDelay = "5000";

        public boolean isEnabled() {
            return enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getInitialDelay() {
            return initialDelay;
        }

        public void setInitialDelay(String initialDelay) {
            this.initialDelay = initialDelay;
        }

        public String getFetchDelay() {
            return fetchDelay;
        }

        public void setFetchDelay(String fetchDelay) {
            this.fetchDelay = fetchDelay;
        }
    }
}
