package de.otto.eventsourcing.command;

import de.otto.eventsourcing.event.Key;
import de.otto.eventsourcing.event.Payload;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class SimpleCommandFactory<T> implements CommandFactory<T> {

    private final String topic;
    private final Function<T, Key> keyMapper;
    private final Function<T, Payload> payloadMapper;


    public SimpleCommandFactory(final String topic,
                                final Function<T, Key> keyMapper,
                                final Function<T, Payload> payloadMapper) {
        this.topic = topic;
        this.keyMapper = keyMapper;
        this.payloadMapper = payloadMapper;
    }

    @Override
    public List<Command> putEventsFor(final T entity) {
        return Collections.singletonList(new Command(
                topic,
                keyMapper.apply(entity),
                payloadMapper.apply(entity)));
    }

    @Override
    public List<Command> deleteEventsFor(final String entityId) {
        return Collections.singletonList(new Command(
                topic,
                entityId,
                null));
    }

}
