package de.otto.eventsourcing.command;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.eventsourcing.event.Payload;

import java.util.function.Function;

public class JacksonPayloadMapper<T> implements Function<T, Payload> {

    private final ObjectMapper objectMapper;

    public JacksonPayloadMapper(final ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    /**
     * Applies this function to the given argument.
     *
     * @param t the function argument
     * @return the function result
     */
    @Override
    public Payload apply(T t) {
        return objectMapper.convertValue(t, Payload.class);
    }
}
