package de.otto.eventsourcing.command;

import java.util.List;

public interface CommandFactory<T> {

    default List<Command> patchEventsFor(final T entity) {
        throw new UnsupportedOperationException("PATCH is not supported");
    }

    List<Command> putEventsFor(final T entity);

    List<Command> deleteEventsFor(final String entityId);

}
