package de.otto.eventsourcing.command;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.otto.eventsourcing.event.Key;
import de.otto.eventsourcing.event.Payload;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import static java.util.Objects.requireNonNull;

@JsonInclude(NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Command {

    @JsonProperty
    private String topic;
    @JsonProperty
    private Key key;
    @JsonProperty
    private Payload payload;

    Command() {
        this.topic = null;
        this.key = null;
        this.payload = null;
    }

    public Command(final String topic,
                   final String entityId,
                   final Payload payload) {
        this(topic, Key.of(entityId), payload);
    }

    public Command(final String topic,
                   final Key key,
                   final Payload payload) {
        this.topic = requireNonNull(topic);
        this.key = requireNonNull(key);
        this.payload = payload;
    }

    public String getTopic() {
        return topic;
    }

    public Key getKey() {
        return key;
    }

    public Payload getPayload() {
        return payload;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Command command = (Command) o;
        return Objects.equals(topic, command.topic) &&
                Objects.equals(key, command.key) &&
                Objects.equals(payload, command.payload);
    }

    @Override
    public int hashCode() {
        return Objects.hash(topic, key, payload);
    }

    @Override
    public String toString() {
        return "Event{" +
                "topic='" + topic + '\'' +
                ", key=" + key +
                ", payload=" + payload +
                '}';
    }
}
