/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.query;

import de.otto.eventsourcing.event.Event;
import de.otto.eventsourcing.query.EventProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class QueryService<T> {
    private static final Logger LOG = LoggerFactory.getLogger(QueryService.class);
    private final ConcurrentMap<String, T> comboState = new ConcurrentHashMap<String, T>(1000);
    private final List<ListenableFutureCallback<Event>> callbacks = new CopyOnWriteArrayList<ListenableFutureCallback<Event>>();
    private final EventProcessor<T> eventProcessor;

    protected QueryService(EventProcessor<T> eventProcessor) {
        this.eventProcessor = eventProcessor;
    }

    public final void addCallback(ListenableFutureCallback<Event> callback) {
        this.callbacks.add(callback);
        LOG.trace("Registered Callback #{}", (Object)this.callbacks.size());
    }

    public final void removeCallback(ListenableFutureCallback<Event> callback) {
        this.callbacks.remove(callback);
        LOG.trace("Unregistered Callback. #{} remaining.", (Object)this.callbacks.size());
    }

    public void receive(Event event) {
        switch (event.getType()) {
            case CREATE: {
                this.comboState.computeIfAbsent(event.getKey().getEntityId(), x -> this.eventProcessor.process(event, Optional.empty()));
                break;
            }
            case PUT: {
                this.comboState.compute(event.getKey().getEntityId(), (x, existing) -> this.eventProcessor.process(event, Optional.ofNullable(existing)));
                break;
            }
            case PATCH: {
                this.comboState.computeIfPresent(event.getKey().getEntityId(), (x, existing) -> this.eventProcessor.process(event, Optional.of(existing)));
                break;
            }
            case DELETE: {
                this.comboState.remove(event.getKey().getEntityId());
            }
        }
        LOG.trace("Received event='{}'", (Object)event);
        this.callbacks.forEach(c -> c.onSuccess((Object)event));
    }

    public final T get(String id) {
        return (T)this.comboState.get(id);
    }

    public final Collection<T> getAll() {
        return Collections.unmodifiableCollection(this.comboState.values());
    }

    public final int size() {
        return this.comboState.size();
    }

    public final void deleteAll() {
        this.comboState.clear();
    }
}

