/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.event;

import de.otto.eventsourcing.event.Event;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.springframework.util.concurrent.ListenableFutureCallback;

public final class EventLog
implements ListenableFutureCallback<Event> {
    private final int maxSize;
    private final Deque<Event> events = new ConcurrentLinkedDeque<Event>();
    private volatile Throwable lastError = null;

    public EventLog() {
        this(100);
    }

    public EventLog(int maxSize) {
        this.maxSize = maxSize;
    }

    public synchronized void onFailure(Throwable ex) {
        this.lastError = ex;
    }

    public synchronized void onSuccess(Event event) {
        this.events.addFirst(event);
        if (this.events.size() > this.maxSize) {
            this.events.removeLast();
        }
    }

    public Deque<Event> getEvents() {
        return new ArrayDeque<Event>(this.events);
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public void clear() {
        this.lastError = null;
        this.events.clear();
    }
}

