/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.event;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.otto.eventsourcing.event.Key;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Event {
    @JsonProperty
    private Key key;
    @JsonProperty
    private Type type;
    @JsonProperty
    private Map<String, Object> payload;

    Event() {
        this.type = null;
        this.key = null;
        this.payload = null;
    }

    public Event(Type type, String entityId, Map<String, Object> payload) {
        this.type = type;
        this.key = new Key(entityId);
        this.payload = payload;
    }

    public Event(Type type, Key key, Map<String, Object> payload) {
        this.type = type;
        this.key = key;
        this.payload = payload;
    }

    public Key getKey() {
        return this.key;
    }

    public Type getType() {
        return this.type;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.key, event.key) && this.type == event.type && Objects.equals(this.payload, event.payload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.type, this.payload});
    }

    public String toString() {
        return "Event{key='" + this.key + '\'' + ", type=" + (Object)((Object)this.type) + ", payload=" + this.payload + '}';
    }

    public static enum Type {
        CREATE,
        PUT,
        PATCH,
        DELETE;

    }
}

