/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.eventsourcing.event.Event;
import de.otto.eventsourcing.event.Key;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.LoggingProducerListener;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.kafka.support.serializer.JsonSerializer;

@EnableConfigurationProperties(value={KafkaProperties.class})
@Configuration
public class KafkaProducerConfiguration {
    @Bean
    public ProducerFactory<Key, Event> eventProducerFactory(Serializer<Key> keySerializer, Serializer<Event> eventSerializer, KafkaProperties kafkaProperties) {
        return new DefaultKafkaProducerFactory(kafkaProperties.buildProducerProperties(), keySerializer, eventSerializer);
    }

    @Bean
    public ProducerListener<Key, Event> eventProducerListener() {
        return new LoggingProducerListener();
    }

    @Bean
    public KafkaTemplate<Key, Event> eventKafkaTemplate(ProducerFactory<Key, Event> eventProducerFactory, ProducerListener<Key, Event> eventProducerListener, KafkaProperties kafkaProperties) {
        KafkaTemplate kafkaTemplate = new KafkaTemplate(eventProducerFactory);
        kafkaTemplate.setDefaultTopic(kafkaProperties.getTemplate().getDefaultTopic());
        kafkaTemplate.setProducerListener(eventProducerListener);
        return kafkaTemplate;
    }

    @Bean
    public Serializer<Key> keySerializer(ObjectMapper objectMapper) {
        return new JsonSerializer(objectMapper);
    }

    @Bean
    public Serializer<Event> eventSerializer(ObjectMapper objectMapper) {
        return new JsonSerializer(objectMapper);
    }
}

