/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.eventsourcing.event.Event;
import de.otto.eventsourcing.event.Key;
import java.util.Objects;
import java.util.UUID;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.support.serializer.JsonDeserializer;

@EnableConfigurationProperties(value={KafkaProperties.class})
@Configuration
public class KafkaConsumerConfiguration {
    @Bean
    public ConcurrentKafkaListenerContainerFactory<Key, Event> kafkaListenerContainerFactory(ConsumerFactory<Key, Event> eventConsumerFactory) {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(eventConsumerFactory);
        return factory;
    }

    @Bean
    public ConsumerFactory<Key, Event> eventConsumerFactory(KafkaProperties kafkaProperties, Deserializer<Key> keyDeserializer, Deserializer<Event> eventDeserializer) {
        if (Objects.toString(kafkaProperties.getConsumer().getGroupId(), "").isEmpty()) {
            kafkaProperties.getConsumer().setGroupId(UUID.randomUUID().toString());
        }
        return new DefaultKafkaConsumerFactory(kafkaProperties.buildConsumerProperties(), keyDeserializer, eventDeserializer);
    }

    @Bean
    public Deserializer<Key> keyDeserializer(ObjectMapper objectMapper) {
        return new JsonDeserializer(Key.class, objectMapper);
    }

    @Bean
    public Deserializer<Event> eventDeserializer() {
        return new JsonDeserializer(Event.class);
    }
}

