/*
 * Decompiled with CFR 0.152.
 */
package de.otto.eventsourcing.command;

import de.otto.eventsourcing.command.EventFactory;
import de.otto.eventsourcing.event.Event;
import de.otto.eventsourcing.event.Key;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.messaging.support.MessageBuilder;

public class CommandService<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CommandService.class);
    private final KafkaTemplate<Key, Event> kafka;
    private final EventFactory<T> eventFactory;
    private final String topic;

    public CommandService(KafkaTemplate<Key, Event> eventKafkaTemplate, EventFactory<T> eventFactory, String topic) {
        this.kafka = eventKafkaTemplate;
        this.eventFactory = eventFactory;
        this.topic = topic;
    }

    public CommandService(KafkaTemplate<Key, Event> eventKafkaTemplate, EventFactory<T> eventFactory, KafkaProperties kafkaProperties) {
        this(eventKafkaTemplate, eventFactory, kafkaProperties.getTemplate().getDefaultTopic());
    }

    protected void send(List<Event> events) {
        events.forEach(this::send);
    }

    protected void send(Event event) {
        LOG.trace("Sending event='{}' to topic='{}'", (Object)event, (Object)this.topic);
        this.kafka.send(MessageBuilder.withPayload((Object)event).setHeader("kafka_messageKey", (Object)event.getKey()).setHeader("kafka_topic", (Object)this.topic).build());
    }

    public void create(T entity) {
        this.send(this.eventFactory.createEventsFor(entity));
    }

    public void put(T entity) {
        this.send(this.eventFactory.putEventsFor(entity));
    }

    public void patch(T entity) {
        this.send(this.eventFactory.patchEventsFor(entity));
    }

    public void delete(String entityId) {
        this.send(this.eventFactory.deleteEventsFor(entityId));
    }
}

