package de.otto.eventsourcing.event;

import org.springframework.util.concurrent.ListenableFutureCallback;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;

public final class EventLog implements ListenableFutureCallback<Event> {

    private final int maxSize;
    private final Deque<Event> events = new ConcurrentLinkedDeque<>();
    private volatile Throwable lastError = null;

    public EventLog() {
        this(100);
    }

    public EventLog(final int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public synchronized void onFailure(Throwable ex) {
        lastError = ex;
    }

    @Override
    public synchronized void onSuccess(Event event) {
        events.addFirst(event);
        if (events.size() > maxSize) {
            events.removeLast();
        }
    }

    public Deque<Event> getEvents() {
        return new ArrayDeque<>(events);
    }

    public Throwable getLastError() {
        return lastError;
    }

    public void clear() {
        lastError = null;
        events.clear();
    }
}
