package de.otto.eventsourcing.event;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Map;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Event {

    public enum Type {
        CREATE, PUT, PATCH, DELETE;
    }

    @JsonProperty
    private Key key;

    @JsonProperty
    private Type type;
    @JsonProperty
    private Map<String, Object> payload;

    Event() {
        this.type = null;
        this.key = null;
        this.payload = null;
    }

    public Event(final Type type,
                 final String entityId,
                 final Map<String, Object> payload) {
        this.type = type;
        this.key = new Key(entityId);
        this.payload = payload;
    }

    public Event(final Type type,
                 final Key key,
                 final Map<String, Object> payload) {
        this.type = type;
        this.key = key;
        this.payload = payload;
    }

    public Key getKey() {
        return key;
    }

    public Type getType() {
        return type;
    }

    public Map<String, Object> getPayload() {
        return payload;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Event event = (Event) o;
        return Objects.equals(key, event.key) &&
                type == event.type &&
                Objects.equals(payload, event.payload);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, type, payload);
    }

    @Override
    public String toString() {
        return "Event{" +
                "key='" + key + '\'' +
                ", type=" + type +
                ", payload=" + payload +
                '}';
    }
}
