/*
 * Decompiled with CFR 0.152.
 */
package de.otto.esidialect.thymeleaf3;

import de.otto.esidialect.EsiContentResolver;
import java.util.List;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.context.WebEngineContext;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractElementTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public class EsiIncludeElementProcessor
extends AbstractElementTagProcessor {
    private EsiContentResolver esiContentResolver;
    private List<String> enabledUris;

    protected EsiIncludeElementProcessor(EsiContentResolver esiContentResolver, List<String> enabledUris) {
        super(TemplateMode.HTML, "esi", "include", true, null, false, 1000);
        this.esiContentResolver = esiContentResolver;
        this.enabledUris = enabledUris;
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, IElementTagStructureHandler structureHandler) {
        if (this.enabledUris == null || this.enabledUris.isEmpty() || this.enabledUris.stream().anyMatch(uri -> ((WebEngineContext)context).getExchange().getRequest().getRequestURL().startsWith((String)uri))) {
            String src = tag.getAttributeValue("src");
            String body = this.esiContentResolver.fetch(src, tag.getTemplateName(), this.continueOnError(tag.getAttributeValue("onerror")));
            structureHandler.replaceWith((CharSequence)body, false);
        }
    }

    private boolean continueOnError(String onerror) {
        return "continue".equals(onerror);
    }
}

